package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSuiteResponse(
    suite: Optional[zio.aws.devicefarm.model.Suite] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetSuiteResponse = {
    import GetSuiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetSuiteResponse
      .builder()
      .optionallyWith(suite.map(value => value.buildAwsValue()))(_.suite)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetSuiteResponse.ReadOnly =
    zio.aws.devicefarm.model.GetSuiteResponse.wrap(buildAwsValue())
}
object GetSuiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetSuiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetSuiteResponse =
      zio.aws.devicefarm.model
        .GetSuiteResponse(suite.map(value => value.asEditable))
    def suite: Optional[zio.aws.devicefarm.model.Suite.ReadOnly]
    def getSuite: ZIO[Any, AwsError, zio.aws.devicefarm.model.Suite.ReadOnly] =
      AwsError.unwrapOptionField("suite", suite)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetSuiteResponse
  ) extends zio.aws.devicefarm.model.GetSuiteResponse.ReadOnly {
    override val suite: Optional[zio.aws.devicefarm.model.Suite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suite())
        .map(value => zio.aws.devicefarm.model.Suite.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetSuiteResponse
  ): zio.aws.devicefarm.model.GetSuiteResponse.ReadOnly = new Wrapper(impl)
}
