package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetUploadResponse(
    upload: Optional[zio.aws.devicefarm.model.Upload] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetUploadResponse = {
    import GetUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetUploadResponse
      .builder()
      .optionallyWith(upload.map(value => value.buildAwsValue()))(_.upload)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetUploadResponse.ReadOnly =
    zio.aws.devicefarm.model.GetUploadResponse.wrap(buildAwsValue())
}
object GetUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetUploadResponse =
      zio.aws.devicefarm.model
        .GetUploadResponse(upload.map(value => value.asEditable))
    def upload: Optional[zio.aws.devicefarm.model.Upload.ReadOnly]
    def getUpload
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Upload.ReadOnly] =
      AwsError.unwrapOptionField("upload", upload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetUploadResponse
  ) extends zio.aws.devicefarm.model.GetUploadResponse.ReadOnly {
    override val upload: Optional[zio.aws.devicefarm.model.Upload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upload())
        .map(value => zio.aws.devicefarm.model.Upload.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetUploadResponse
  ): zio.aws.devicefarm.model.GetUploadResponse.ReadOnly = new Wrapper(impl)
}
