package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Message
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IncompatibilityMessage(
    message: Optional[Message] = Optional.Absent,
    `type`: Optional[zio.aws.devicefarm.model.DeviceAttribute] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessage = {
    import IncompatibilityMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessage
      .builder()
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.IncompatibilityMessage.ReadOnly =
    zio.aws.devicefarm.model.IncompatibilityMessage.wrap(buildAwsValue())
}
object IncompatibilityMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.IncompatibilityMessage =
      zio.aws.devicefarm.model.IncompatibilityMessage(
        message.map(value => value),
        `type`.map(value => value)
      )
    def message: Optional[Message]
    def `type`: Optional[zio.aws.devicefarm.model.DeviceAttribute]
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceAttribute] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessage
  ) extends zio.aws.devicefarm.model.IncompatibilityMessage.ReadOnly {
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val `type`: Optional[zio.aws.devicefarm.model.DeviceAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.devicefarm.model.DeviceAttribute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.IncompatibilityMessage
  ): zio.aws.devicefarm.model.IncompatibilityMessage.ReadOnly = new Wrapper(
    impl
  )
}
