package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait InstanceStatus {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.InstanceStatus
}
object InstanceStatus {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.InstanceStatus
  ): zio.aws.devicefarm.model.InstanceStatus = value match {
    case software.amazon.awssdk.services.devicefarm.model.InstanceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.InstanceStatus.IN_USE =>
      val r = IN_USE
      r
    case software.amazon.awssdk.services.devicefarm.model.InstanceStatus.PREPARING =>
      val r = PREPARING
      r
    case software.amazon.awssdk.services.devicefarm.model.InstanceStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.devicefarm.model.InstanceStatus.NOT_AVAILABLE =>
      val r = NOT_AVAILABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.InstanceStatus =
      software.amazon.awssdk.services.devicefarm.model.InstanceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_USE extends zio.aws.devicefarm.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.InstanceStatus =
      software.amazon.awssdk.services.devicefarm.model.InstanceStatus.IN_USE
  }
  case object PREPARING extends zio.aws.devicefarm.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.InstanceStatus =
      software.amazon.awssdk.services.devicefarm.model.InstanceStatus.PREPARING
  }
  case object AVAILABLE extends zio.aws.devicefarm.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.InstanceStatus =
      software.amazon.awssdk.services.devicefarm.model.InstanceStatus.AVAILABLE
  }
  case object NOT_AVAILABLE extends zio.aws.devicefarm.model.InstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.InstanceStatus =
      software.amazon.awssdk.services.devicefarm.model.InstanceStatus.NOT_AVAILABLE
  }
}
