package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDeviceInstancesRequest(
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesRequest = {
    import ListDeviceInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListDeviceInstancesRequest.ReadOnly =
    zio.aws.devicefarm.model.ListDeviceInstancesRequest.wrap(buildAwsValue())
}
object ListDeviceInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListDeviceInstancesRequest =
      zio.aws.devicefarm.model.ListDeviceInstancesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[Integer]
    def nextToken: Optional[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesRequest
  ) extends zio.aws.devicefarm.model.ListDeviceInstancesRequest.ReadOnly {
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesRequest
  ): zio.aws.devicefarm.model.ListDeviceInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
