package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDeviceInstancesResponse(
    deviceInstances: Optional[
      Iterable[zio.aws.devicefarm.model.DeviceInstance]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse = {
    import ListDeviceInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse
      .builder()
      .optionallyWith(
        deviceInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceInstances)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly =
    zio.aws.devicefarm.model.ListDeviceInstancesResponse.wrap(buildAwsValue())
}
object ListDeviceInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListDeviceInstancesResponse =
      zio.aws.devicefarm.model.ListDeviceInstancesResponse(
        deviceInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def deviceInstances
        : Optional[List[zio.aws.devicefarm.model.DeviceInstance.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getDeviceInstances: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.DeviceInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceInstances", deviceInstances)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse
  ) extends zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly {
    override val deviceInstances
        : Optional[List[zio.aws.devicefarm.model.DeviceInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.DeviceInstance.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDeviceInstancesResponse
  ): zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
