package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListNetworkProfilesResponse(
    networkProfiles: Optional[
      Iterable[zio.aws.devicefarm.model.NetworkProfile]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse = {
    import ListNetworkProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse
      .builder()
      .optionallyWith(
        networkProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkProfiles)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly =
    zio.aws.devicefarm.model.ListNetworkProfilesResponse.wrap(buildAwsValue())
}
object ListNetworkProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListNetworkProfilesResponse =
      zio.aws.devicefarm.model.ListNetworkProfilesResponse(
        networkProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkProfiles
        : Optional[List[zio.aws.devicefarm.model.NetworkProfile.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getNetworkProfiles: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.NetworkProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("networkProfiles", networkProfiles)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse
  ) extends zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly {
    override val networkProfiles
        : Optional[List[zio.aws.devicefarm.model.NetworkProfile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkProfiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.NetworkProfile.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListNetworkProfilesResponse
  ): zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
