package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListOfferingPromotionsResponse(
    offeringPromotions: Optional[
      Iterable[zio.aws.devicefarm.model.OfferingPromotion]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse = {
    import ListOfferingPromotionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse
      .builder()
      .optionallyWith(
        offeringPromotions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.offeringPromotions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListOfferingPromotionsResponse
      .wrap(buildAwsValue())
}
object ListOfferingPromotionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListOfferingPromotionsResponse =
      zio.aws.devicefarm.model.ListOfferingPromotionsResponse(
        offeringPromotions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def offeringPromotions
        : Optional[List[zio.aws.devicefarm.model.OfferingPromotion.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getOfferingPromotions: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.OfferingPromotion.ReadOnly
    ]] = AwsError.unwrapOptionField("offeringPromotions", offeringPromotions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse
  ) extends zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly {
    override val offeringPromotions
        : Optional[List[zio.aws.devicefarm.model.OfferingPromotion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringPromotions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.OfferingPromotion.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListOfferingPromotionsResponse
  ): zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly =
    new Wrapper(impl)
}
