package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListOfferingTransactionsResponse(
    offeringTransactions: Optional[
      Iterable[zio.aws.devicefarm.model.OfferingTransaction]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse = {
    import ListOfferingTransactionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse
      .builder()
      .optionallyWith(
        offeringTransactions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.offeringTransactions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListOfferingTransactionsResponse
      .wrap(buildAwsValue())
}
object ListOfferingTransactionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListOfferingTransactionsResponse =
      zio.aws.devicefarm.model.ListOfferingTransactionsResponse(
        offeringTransactions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def offeringTransactions
        : Optional[List[zio.aws.devicefarm.model.OfferingTransaction.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getOfferingTransactions: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.OfferingTransaction.ReadOnly
    ]] =
      AwsError.unwrapOptionField("offeringTransactions", offeringTransactions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse
  ) extends zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly {
    override val offeringTransactions: Optional[
      List[zio.aws.devicefarm.model.OfferingTransaction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringTransactions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.OfferingTransaction.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListOfferingTransactionsResponse
  ): zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly =
    new Wrapper(impl)
}
