package zio.aws.devicefarm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  PaginationToken,
  MaxPageSize,
  DeviceFarmArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListTestGridSessionArtifactsRequest(
    sessionArn: DeviceFarmArn,
    `type`: Optional[zio.aws.devicefarm.model.TestGridSessionArtifactCategory] =
      Optional.Absent,
    maxResult: Optional[MaxPageSize] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest = {
    import ListTestGridSessionArtifactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest
      .builder()
      .sessionArn(DeviceFarmArn.unwrap(sessionArn): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        maxResult.map(value => MaxPageSize.unwrap(value): Integer)
      )(_.maxResult)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListTestGridSessionArtifactsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListTestGridSessionArtifactsRequest
      .wrap(buildAwsValue())
}
object ListTestGridSessionArtifactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devicefarm.model.ListTestGridSessionArtifactsRequest =
      zio.aws.devicefarm.model.ListTestGridSessionArtifactsRequest(
        sessionArn,
        `type`.map(value => value),
        maxResult.map(value => value),
        nextToken.map(value => value)
      )
    def sessionArn: DeviceFarmArn
    def `type`
        : Optional[zio.aws.devicefarm.model.TestGridSessionArtifactCategory]
    def maxResult: Optional[MaxPageSize]
    def nextToken: Optional[PaginationToken]
    def getSessionArn: ZIO[Any, Nothing, DeviceFarmArn] =
      ZIO.succeed(sessionArn)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.TestGridSessionArtifactCategory
    ] = AwsError.unwrapOptionField("type", `type`)
    def getMaxResult: ZIO[Any, AwsError, MaxPageSize] =
      AwsError.unwrapOptionField("maxResult", maxResult)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest
  ) extends zio.aws.devicefarm.model.ListTestGridSessionArtifactsRequest.ReadOnly {
    override val sessionArn: DeviceFarmArn =
      zio.aws.devicefarm.model.primitives.DeviceFarmArn(impl.sessionArn())
    override val `type`
        : Optional[zio.aws.devicefarm.model.TestGridSessionArtifactCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.devicefarm.model.TestGridSessionArtifactCategory.wrap(value)
        )
    override val maxResult: Optional[MaxPageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResult())
      .map(value => zio.aws.devicefarm.model.primitives.MaxPageSize(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsRequest
  ): zio.aws.devicefarm.model.ListTestGridSessionArtifactsRequest.ReadOnly =
    new Wrapper(impl)
}
