package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListVpceConfigurationsResponse(
    vpceConfigurations: Optional[
      Iterable[zio.aws.devicefarm.model.VPCEConfiguration]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse = {
    import ListVpceConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse
      .builder()
      .optionallyWith(
        vpceConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpceConfigurations)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListVpceConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListVpceConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListVpceConfigurationsResponse =
      zio.aws.devicefarm.model.ListVpceConfigurationsResponse(
        vpceConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vpceConfigurations
        : Optional[List[zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getVpceConfigurations: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("vpceConfigurations", vpceConfigurations)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse
  ) extends zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly {
    override val vpceConfigurations
        : Optional[List[zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpceConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.VPCEConfiguration.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListVpceConfigurationsResponse
  ): zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
