package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait NetworkProfileType {
  def unwrap
      : software.amazon.awssdk.services.devicefarm.model.NetworkProfileType
}
object NetworkProfileType {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.NetworkProfileType
  ): zio.aws.devicefarm.model.NetworkProfileType = value match {
    case software.amazon.awssdk.services.devicefarm.model.NetworkProfileType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.NetworkProfileType.CURATED =>
      val r = CURATED
      r
    case software.amazon.awssdk.services.devicefarm.model.NetworkProfileType.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.NetworkProfileType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.NetworkProfileType =
      software.amazon.awssdk.services.devicefarm.model.NetworkProfileType.UNKNOWN_TO_SDK_VERSION
  }
  case object CURATED extends zio.aws.devicefarm.model.NetworkProfileType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.NetworkProfileType =
      software.amazon.awssdk.services.devicefarm.model.NetworkProfileType.CURATED
  }
  case object PRIVATE extends zio.aws.devicefarm.model.NetworkProfileType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.NetworkProfileType =
      software.amazon.awssdk.services.devicefarm.model.NetworkProfileType.PRIVATE
  }
}
