package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  Message,
  OfferingPromotionIdentifier
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OfferingPromotion(
    id: Optional[OfferingPromotionIdentifier] = Optional.Absent,
    description: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.OfferingPromotion = {
    import OfferingPromotion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.OfferingPromotion
      .builder()
      .optionallyWith(
        id.map(value =>
          OfferingPromotionIdentifier.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.OfferingPromotion.ReadOnly =
    zio.aws.devicefarm.model.OfferingPromotion.wrap(buildAwsValue())
}
object OfferingPromotion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.OfferingPromotion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.OfferingPromotion =
      zio.aws.devicefarm.model.OfferingPromotion(
        id.map(value => value),
        description.map(value => value)
      )
    def id: Optional[OfferingPromotionIdentifier]
    def description: Optional[Message]
    def getId: ZIO[Any, AwsError, OfferingPromotionIdentifier] =
      AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.OfferingPromotion
  ) extends zio.aws.devicefarm.model.OfferingPromotion.ReadOnly {
    override val id: Optional[OfferingPromotionIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          zio.aws.devicefarm.model.primitives.OfferingPromotionIdentifier(value)
        )
    override val description: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.OfferingPromotion
  ): zio.aws.devicefarm.model.OfferingPromotion.ReadOnly = new Wrapper(impl)
}
