package zio.aws.devicefarm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{DateTime, Integer}
import scala.jdk.CollectionConverters.*
final case class OfferingStatus(
    `type`: Optional[zio.aws.devicefarm.model.OfferingTransactionType] =
      Optional.Absent,
    offering: Optional[zio.aws.devicefarm.model.Offering] = Optional.Absent,
    quantity: Optional[Integer] = Optional.Absent,
    effectiveOn: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.OfferingStatus = {
    import OfferingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.OfferingStatus
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(offering.map(value => value.buildAwsValue()))(_.offering)
      .optionallyWith(quantity.map(value => value: java.lang.Integer))(
        _.quantity
      )
      .optionallyWith(
        effectiveOn.map(value => DateTime.unwrap(value): Instant)
      )(_.effectiveOn)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.OfferingStatus.ReadOnly =
    zio.aws.devicefarm.model.OfferingStatus.wrap(buildAwsValue())
}
object OfferingStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.OfferingStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.OfferingStatus =
      zio.aws.devicefarm.model.OfferingStatus(
        `type`.map(value => value),
        offering.map(value => value.asEditable),
        quantity.map(value => value),
        effectiveOn.map(value => value)
      )
    def `type`: Optional[zio.aws.devicefarm.model.OfferingTransactionType]
    def offering: Optional[zio.aws.devicefarm.model.Offering.ReadOnly]
    def quantity: Optional[Integer]
    def effectiveOn: Optional[DateTime]
    def getType
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.OfferingTransactionType] =
      AwsError.unwrapOptionField("type", `type`)
    def getOffering
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Offering.ReadOnly] =
      AwsError.unwrapOptionField("offering", offering)
    def getQuantity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("quantity", quantity)
    def getEffectiveOn: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("effectiveOn", effectiveOn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.OfferingStatus
  ) extends zio.aws.devicefarm.model.OfferingStatus.ReadOnly {
    override val `type`
        : Optional[zio.aws.devicefarm.model.OfferingTransactionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.devicefarm.model.OfferingTransactionType.wrap(value)
        )
    override val offering
        : Optional[zio.aws.devicefarm.model.Offering.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offering())
        .map(value => zio.aws.devicefarm.model.Offering.wrap(value))
    override val quantity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.quantity())
      .map(value => value: Integer)
    override val effectiveOn: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.effectiveOn())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.OfferingStatus
  ): zio.aws.devicefarm.model.OfferingStatus.ReadOnly = new Wrapper(impl)
}
