package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Name, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProblemDetail(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    name: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ProblemDetail = {
    import ProblemDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ProblemDetail
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ProblemDetail.ReadOnly =
    zio.aws.devicefarm.model.ProblemDetail.wrap(buildAwsValue())
}
object ProblemDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ProblemDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ProblemDetail =
      zio.aws.devicefarm.model
        .ProblemDetail(arn.map(value => value), name.map(value => value))
    def arn: Optional[AmazonResourceName]
    def name: Optional[Name]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ProblemDetail
  ) extends zio.aws.devicefarm.model.ProblemDetail.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ProblemDetail
  ): zio.aws.devicefarm.model.ProblemDetail.ReadOnly = new Wrapper(impl)
}
