package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Radios(
    wifi: Optional[Boolean] = Optional.Absent,
    bluetooth: Optional[Boolean] = Optional.Absent,
    nfc: Optional[Boolean] = Optional.Absent,
    gps: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Radios = {
    import Radios.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Radios
      .builder()
      .optionallyWith(wifi.map(value => value: java.lang.Boolean))(_.wifi)
      .optionallyWith(bluetooth.map(value => value: java.lang.Boolean))(
        _.bluetooth
      )
      .optionallyWith(nfc.map(value => value: java.lang.Boolean))(_.nfc)
      .optionallyWith(gps.map(value => value: java.lang.Boolean))(_.gps)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Radios.ReadOnly =
    zio.aws.devicefarm.model.Radios.wrap(buildAwsValue())
}
object Radios {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Radios] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Radios =
      zio.aws.devicefarm.model.Radios(
        wifi.map(value => value),
        bluetooth.map(value => value),
        nfc.map(value => value),
        gps.map(value => value)
      )
    def wifi: Optional[Boolean]
    def bluetooth: Optional[Boolean]
    def nfc: Optional[Boolean]
    def gps: Optional[Boolean]
    def getWifi: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("wifi", wifi)
    def getBluetooth: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("bluetooth", bluetooth)
    def getNfc: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("nfc", nfc)
    def getGps: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("gps", gps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Radios
  ) extends zio.aws.devicefarm.model.Radios.ReadOnly {
    override val wifi: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.wifi())
      .map(value => value: Boolean)
    override val bluetooth: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.bluetooth())
      .map(value => value: Boolean)
    override val nfc: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.nfc())
      .map(value => value: Boolean)
    override val gps: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.gps())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Radios
  ): zio.aws.devicefarm.model.Radios.ReadOnly = new Wrapper(impl)
}
