package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{Integer, OfferingIdentifier}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RenewOfferingRequest(
    offeringId: OfferingIdentifier,
    quantity: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest = {
    import RenewOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest
      .builder()
      .offeringId(OfferingIdentifier.unwrap(offeringId): java.lang.String)
      .quantity(quantity: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.RenewOfferingRequest.ReadOnly =
    zio.aws.devicefarm.model.RenewOfferingRequest.wrap(buildAwsValue())
}
object RenewOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.RenewOfferingRequest =
      zio.aws.devicefarm.model.RenewOfferingRequest(offeringId, quantity)
    def offeringId: OfferingIdentifier
    def quantity: Integer
    def getOfferingId: ZIO[Any, Nothing, OfferingIdentifier] =
      ZIO.succeed(offeringId)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest
  ) extends zio.aws.devicefarm.model.RenewOfferingRequest.ReadOnly {
    override val offeringId: OfferingIdentifier =
      zio.aws.devicefarm.model.primitives.OfferingIdentifier(impl.offeringId())
    override val quantity: Integer = impl.quantity(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.RenewOfferingRequest
  ): zio.aws.devicefarm.model.RenewOfferingRequest.ReadOnly = new Wrapper(impl)
}
