package zio.aws.devicefarm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  JobTimeoutMinutes,
  Message,
  DateTime,
  SkipAppResign,
  Integer,
  AmazonResourceName,
  Name
}
import scala.jdk.CollectionConverters.*
final case class Run(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    `type`: Optional[zio.aws.devicefarm.model.TestType] = Optional.Absent,
    platform: Optional[zio.aws.devicefarm.model.DevicePlatform] =
      Optional.Absent,
    created: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.devicefarm.model.ExecutionStatus] =
      Optional.Absent,
    result: Optional[zio.aws.devicefarm.model.ExecutionResult] =
      Optional.Absent,
    started: Optional[DateTime] = Optional.Absent,
    stopped: Optional[DateTime] = Optional.Absent,
    counters: Optional[zio.aws.devicefarm.model.Counters] = Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    totalJobs: Optional[Integer] = Optional.Absent,
    completedJobs: Optional[Integer] = Optional.Absent,
    billingMethod: Optional[zio.aws.devicefarm.model.BillingMethod] =
      Optional.Absent,
    deviceMinutes: Optional[zio.aws.devicefarm.model.DeviceMinutes] =
      Optional.Absent,
    networkProfile: Optional[zio.aws.devicefarm.model.NetworkProfile] =
      Optional.Absent,
    parsingResultUrl: Optional[String] = Optional.Absent,
    resultCode: Optional[zio.aws.devicefarm.model.ExecutionResultCode] =
      Optional.Absent,
    seed: Optional[Integer] = Optional.Absent,
    appUpload: Optional[AmazonResourceName] = Optional.Absent,
    eventCount: Optional[Integer] = Optional.Absent,
    jobTimeoutMinutes: Optional[JobTimeoutMinutes] = Optional.Absent,
    devicePoolArn: Optional[AmazonResourceName] = Optional.Absent,
    locale: Optional[String] = Optional.Absent,
    radios: Optional[zio.aws.devicefarm.model.Radios] = Optional.Absent,
    location: Optional[zio.aws.devicefarm.model.Location] = Optional.Absent,
    customerArtifactPaths: Optional[
      zio.aws.devicefarm.model.CustomerArtifactPaths
    ] = Optional.Absent,
    webUrl: Optional[String] = Optional.Absent,
    skipAppResign: Optional[SkipAppResign] = Optional.Absent,
    testSpecArn: Optional[AmazonResourceName] = Optional.Absent,
    deviceSelectionResult: Optional[
      zio.aws.devicefarm.model.DeviceSelectionResult
    ] = Optional.Absent,
    vpcConfig: Optional[zio.aws.devicefarm.model.VpcConfig] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.devicefarm.model.Run = {
    import Run.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Run
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(started.map(value => DateTime.unwrap(value): Instant))(
        _.started
      )
      .optionallyWith(stopped.map(value => DateTime.unwrap(value): Instant))(
        _.stopped
      )
      .optionallyWith(counters.map(value => value.buildAwsValue()))(_.counters)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(totalJobs.map(value => value: java.lang.Integer))(
        _.totalJobs
      )
      .optionallyWith(completedJobs.map(value => value: java.lang.Integer))(
        _.completedJobs
      )
      .optionallyWith(billingMethod.map(value => value.unwrap))(_.billingMethod)
      .optionallyWith(deviceMinutes.map(value => value.buildAwsValue()))(
        _.deviceMinutes
      )
      .optionallyWith(networkProfile.map(value => value.buildAwsValue()))(
        _.networkProfile
      )
      .optionallyWith(parsingResultUrl.map(value => value: java.lang.String))(
        _.parsingResultUrl
      )
      .optionallyWith(resultCode.map(value => value.unwrap))(_.resultCode)
      .optionallyWith(seed.map(value => value: java.lang.Integer))(_.seed)
      .optionallyWith(
        appUpload.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.appUpload)
      .optionallyWith(eventCount.map(value => value: java.lang.Integer))(
        _.eventCount
      )
      .optionallyWith(
        jobTimeoutMinutes.map(value =>
          JobTimeoutMinutes.unwrap(value): java.lang.Integer
        )
      )(_.jobTimeoutMinutes)
      .optionallyWith(
        devicePoolArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.devicePoolArn)
      .optionallyWith(locale.map(value => value: java.lang.String))(_.locale)
      .optionallyWith(radios.map(value => value.buildAwsValue()))(_.radios)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        customerArtifactPaths.map(value => value.buildAwsValue())
      )(_.customerArtifactPaths)
      .optionallyWith(webUrl.map(value => value: java.lang.String))(_.webUrl)
      .optionallyWith(
        skipAppResign.map(value =>
          SkipAppResign.unwrap(value): java.lang.Boolean
        )
      )(_.skipAppResign)
      .optionallyWith(
        testSpecArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.testSpecArn)
      .optionallyWith(
        deviceSelectionResult.map(value => value.buildAwsValue())
      )(_.deviceSelectionResult)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Run.ReadOnly =
    zio.aws.devicefarm.model.Run.wrap(buildAwsValue())
}
object Run {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Run] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Run = zio.aws.devicefarm.model.Run(
      arn.map(value => value),
      name.map(value => value),
      `type`.map(value => value),
      platform.map(value => value),
      created.map(value => value),
      status.map(value => value),
      result.map(value => value),
      started.map(value => value),
      stopped.map(value => value),
      counters.map(value => value.asEditable),
      message.map(value => value),
      totalJobs.map(value => value),
      completedJobs.map(value => value),
      billingMethod.map(value => value),
      deviceMinutes.map(value => value.asEditable),
      networkProfile.map(value => value.asEditable),
      parsingResultUrl.map(value => value),
      resultCode.map(value => value),
      seed.map(value => value),
      appUpload.map(value => value),
      eventCount.map(value => value),
      jobTimeoutMinutes.map(value => value),
      devicePoolArn.map(value => value),
      locale.map(value => value),
      radios.map(value => value.asEditable),
      location.map(value => value.asEditable),
      customerArtifactPaths.map(value => value.asEditable),
      webUrl.map(value => value),
      skipAppResign.map(value => value),
      testSpecArn.map(value => value),
      deviceSelectionResult.map(value => value.asEditable),
      vpcConfig.map(value => value.asEditable)
    )
    def arn: Optional[AmazonResourceName]
    def name: Optional[Name]
    def `type`: Optional[zio.aws.devicefarm.model.TestType]
    def platform: Optional[zio.aws.devicefarm.model.DevicePlatform]
    def created: Optional[DateTime]
    def status: Optional[zio.aws.devicefarm.model.ExecutionStatus]
    def result: Optional[zio.aws.devicefarm.model.ExecutionResult]
    def started: Optional[DateTime]
    def stopped: Optional[DateTime]
    def counters: Optional[zio.aws.devicefarm.model.Counters.ReadOnly]
    def message: Optional[Message]
    def totalJobs: Optional[Integer]
    def completedJobs: Optional[Integer]
    def billingMethod: Optional[zio.aws.devicefarm.model.BillingMethod]
    def deviceMinutes: Optional[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly]
    def networkProfile
        : Optional[zio.aws.devicefarm.model.NetworkProfile.ReadOnly]
    def parsingResultUrl: Optional[String]
    def resultCode: Optional[zio.aws.devicefarm.model.ExecutionResultCode]
    def seed: Optional[Integer]
    def appUpload: Optional[AmazonResourceName]
    def eventCount: Optional[Integer]
    def jobTimeoutMinutes: Optional[JobTimeoutMinutes]
    def devicePoolArn: Optional[AmazonResourceName]
    def locale: Optional[String]
    def radios: Optional[zio.aws.devicefarm.model.Radios.ReadOnly]
    def location: Optional[zio.aws.devicefarm.model.Location.ReadOnly]
    def customerArtifactPaths
        : Optional[zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly]
    def webUrl: Optional[String]
    def skipAppResign: Optional[SkipAppResign]
    def testSpecArn: Optional[AmazonResourceName]
    def deviceSelectionResult
        : Optional[zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly]
    def vpcConfig: Optional[zio.aws.devicefarm.model.VpcConfig.ReadOnly]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.devicefarm.model.TestType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DevicePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getResult
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResult] =
      AwsError.unwrapOptionField("result", result)
    def getStarted: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("started", started)
    def getStopped: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("stopped", stopped)
    def getCounters
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Counters.ReadOnly] =
      AwsError.unwrapOptionField("counters", counters)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getTotalJobs: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalJobs", totalJobs)
    def getCompletedJobs: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("completedJobs", completedJobs)
    def getBillingMethod
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.BillingMethod] =
      AwsError.unwrapOptionField("billingMethod", billingMethod)
    def getDeviceMinutes
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] =
      AwsError.unwrapOptionField("deviceMinutes", deviceMinutes)
    def getNetworkProfile
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.NetworkProfile.ReadOnly] =
      AwsError.unwrapOptionField("networkProfile", networkProfile)
    def getParsingResultUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parsingResultUrl", parsingResultUrl)
    def getResultCode
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResultCode] =
      AwsError.unwrapOptionField("resultCode", resultCode)
    def getSeed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("seed", seed)
    def getAppUpload: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("appUpload", appUpload)
    def getEventCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("eventCount", eventCount)
    def getJobTimeoutMinutes: ZIO[Any, AwsError, JobTimeoutMinutes] =
      AwsError.unwrapOptionField("jobTimeoutMinutes", jobTimeoutMinutes)
    def getDevicePoolArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("devicePoolArn", devicePoolArn)
    def getLocale: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("locale", locale)
    def getRadios
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Radios.ReadOnly] =
      AwsError.unwrapOptionField("radios", radios)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getCustomerArtifactPaths: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly
    ] =
      AwsError.unwrapOptionField("customerArtifactPaths", customerArtifactPaths)
    def getWebUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("webUrl", webUrl)
    def getSkipAppResign: ZIO[Any, AwsError, SkipAppResign] =
      AwsError.unwrapOptionField("skipAppResign", skipAppResign)
    def getTestSpecArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("testSpecArn", testSpecArn)
    def getDeviceSelectionResult: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly
    ] =
      AwsError.unwrapOptionField("deviceSelectionResult", deviceSelectionResult)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Run
  ) extends zio.aws.devicefarm.model.Run.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val `type`: Optional[zio.aws.devicefarm.model.TestType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.devicefarm.model.TestType.wrap(value))
    override val platform: Optional[zio.aws.devicefarm.model.DevicePlatform] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platform())
        .map(value => zio.aws.devicefarm.model.DevicePlatform.wrap(value))
    override val created: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.devicefarm.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.devicefarm.model.ExecutionStatus.wrap(value))
    override val result: Optional[zio.aws.devicefarm.model.ExecutionResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value => zio.aws.devicefarm.model.ExecutionResult.wrap(value))
    override val started: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.started())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val stopped: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.stopped())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val counters
        : Optional[zio.aws.devicefarm.model.Counters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.counters())
        .map(value => zio.aws.devicefarm.model.Counters.wrap(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val totalJobs: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalJobs())
      .map(value => value: Integer)
    override val completedJobs: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.completedJobs())
      .map(value => value: Integer)
    override val billingMethod
        : Optional[zio.aws.devicefarm.model.BillingMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billingMethod())
        .map(value => zio.aws.devicefarm.model.BillingMethod.wrap(value))
    override val deviceMinutes
        : Optional[zio.aws.devicefarm.model.DeviceMinutes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceMinutes())
        .map(value => zio.aws.devicefarm.model.DeviceMinutes.wrap(value))
    override val networkProfile
        : Optional[zio.aws.devicefarm.model.NetworkProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkProfile())
        .map(value => zio.aws.devicefarm.model.NetworkProfile.wrap(value))
    override val parsingResultUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parsingResultUrl())
      .map(value => value: String)
    override val resultCode
        : Optional[zio.aws.devicefarm.model.ExecutionResultCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resultCode())
        .map(value => zio.aws.devicefarm.model.ExecutionResultCode.wrap(value))
    override val seed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.seed())
      .map(value => value: Integer)
    override val appUpload: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.appUpload())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val eventCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.eventCount())
      .map(value => value: Integer)
    override val jobTimeoutMinutes: Optional[JobTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTimeoutMinutes())
        .map(value =>
          zio.aws.devicefarm.model.primitives.JobTimeoutMinutes(value)
        )
    override val devicePoolArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.devicePoolArn())
        .map(value =>
          zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
        )
    override val locale: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => value: String)
    override val radios: Optional[zio.aws.devicefarm.model.Radios.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.radios())
        .map(value => zio.aws.devicefarm.model.Radios.wrap(value))
    override val location
        : Optional[zio.aws.devicefarm.model.Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.devicefarm.model.Location.wrap(value))
    override val customerArtifactPaths
        : Optional[zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerArtifactPaths())
        .map(value =>
          zio.aws.devicefarm.model.CustomerArtifactPaths.wrap(value)
        )
    override val webUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.webUrl())
      .map(value => value: String)
    override val skipAppResign: Optional[SkipAppResign] = zio.aws.core.internal
      .optionalFromNullable(impl.skipAppResign())
      .map(value => zio.aws.devicefarm.model.primitives.SkipAppResign(value))
    override val testSpecArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testSpecArn())
        .map(value =>
          zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
        )
    override val deviceSelectionResult
        : Optional[zio.aws.devicefarm.model.DeviceSelectionResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceSelectionResult())
        .map(value =>
          zio.aws.devicefarm.model.DeviceSelectionResult.wrap(value)
        )
    override val vpcConfig
        : Optional[zio.aws.devicefarm.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.devicefarm.model.VpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Run
  ): zio.aws.devicefarm.model.Run.ReadOnly = new Wrapper(impl)
}
