package zio.aws.devicefarm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.DateTime
import scala.jdk.CollectionConverters.*
final case class TestGridSessionAction(
    action: Optional[String] = Optional.Absent,
    started: Optional[DateTime] = Optional.Absent,
    duration: Optional[Long] = Optional.Absent,
    statusCode: Optional[String] = Optional.Absent,
    requestMethod: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.TestGridSessionAction = {
    import TestGridSessionAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.TestGridSessionAction
      .builder()
      .optionallyWith(action.map(value => value: java.lang.String))(_.action)
      .optionallyWith(started.map(value => DateTime.unwrap(value): Instant))(
        _.started
      )
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(statusCode.map(value => value: java.lang.String))(
        _.statusCode
      )
      .optionallyWith(requestMethod.map(value => value: java.lang.String))(
        _.requestMethod
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.TestGridSessionAction.ReadOnly =
    zio.aws.devicefarm.model.TestGridSessionAction.wrap(buildAwsValue())
}
object TestGridSessionAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.TestGridSessionAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.TestGridSessionAction =
      zio.aws.devicefarm.model.TestGridSessionAction(
        action.map(value => value),
        started.map(value => value),
        duration.map(value => value),
        statusCode.map(value => value),
        requestMethod.map(value => value)
      )
    def action: Optional[String]
    def started: Optional[DateTime]
    def duration: Optional[Long]
    def statusCode: Optional[String]
    def requestMethod: Optional[String]
    def getAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("action", action)
    def getStarted: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("started", started)
    def getDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("duration", duration)
    def getStatusCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getRequestMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("requestMethod", requestMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.TestGridSessionAction
  ) extends zio.aws.devicefarm.model.TestGridSessionAction.ReadOnly {
    override val action: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value => value: String)
    override val started: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.started())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val duration: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Long)
    override val statusCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value => value: String)
    override val requestMethod: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.requestMethod())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.TestGridSessionAction
  ): zio.aws.devicefarm.model.TestGridSessionAction.ReadOnly = new Wrapper(impl)
}
