package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait TestType {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.TestType
}
object TestType {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.TestType
  ): zio.aws.devicefarm.model.TestType = value match {
    case software.amazon.awssdk.services.devicefarm.model.TestType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.BUILTIN_FUZZ =>
      val r = BUILTIN_FUZZ
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.BUILTIN_EXPLORER =>
      val r = BUILTIN_EXPLORER
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.WEB_PERFORMANCE_PROFILE =>
      val r = WEB_PERFORMANCE_PROFILE
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_JAVA_JUNIT =>
      val r = APPIUM_JAVA_JUNIT
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_JAVA_TESTNG =>
      val r = APPIUM_JAVA_TESTNG
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_PYTHON =>
      val r = APPIUM_PYTHON
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_NODE =>
      val r = APPIUM_NODE
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_RUBY =>
      val r = APPIUM_RUBY
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_WEB_JAVA_JUNIT =>
      val r = APPIUM_WEB_JAVA_JUNIT
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_WEB_JAVA_TESTNG =>
      val r = APPIUM_WEB_JAVA_TESTNG
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_WEB_PYTHON =>
      val r = APPIUM_WEB_PYTHON
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_WEB_NODE =>
      val r = APPIUM_WEB_NODE
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_WEB_RUBY =>
      val r = APPIUM_WEB_RUBY
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.CALABASH =>
      val r = CALABASH
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.INSTRUMENTATION =>
      val r = INSTRUMENTATION
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.UIAUTOMATION =>
      val r = UIAUTOMATION
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.UIAUTOMATOR =>
      val r = UIAUTOMATOR
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.XCTEST =>
      val r = XCTEST
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.XCTEST_UI =>
      val r = XCTEST_UI
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.REMOTE_ACCESS_RECORD =>
      val r = REMOTE_ACCESS_RECORD
      r
    case software.amazon.awssdk.services.devicefarm.model.TestType.REMOTE_ACCESS_REPLAY =>
      val r = REMOTE_ACCESS_REPLAY
      r
  }
  case object unknownToSdkVersion extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.UNKNOWN_TO_SDK_VERSION
  }
  case object BUILTIN_FUZZ extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.BUILTIN_FUZZ
  }
  case object BUILTIN_EXPLORER extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.BUILTIN_EXPLORER
  }
  case object WEB_PERFORMANCE_PROFILE
      extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.WEB_PERFORMANCE_PROFILE
  }
  case object APPIUM_JAVA_JUNIT extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_JAVA_JUNIT
  }
  case object APPIUM_JAVA_TESTNG extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_JAVA_TESTNG
  }
  case object APPIUM_PYTHON extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_PYTHON
  }
  case object APPIUM_NODE extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_NODE
  }
  case object APPIUM_RUBY extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_RUBY
  }
  case object APPIUM_WEB_JAVA_JUNIT extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_WEB_JAVA_JUNIT
  }
  case object APPIUM_WEB_JAVA_TESTNG extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_WEB_JAVA_TESTNG
  }
  case object APPIUM_WEB_PYTHON extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_WEB_PYTHON
  }
  case object APPIUM_WEB_NODE extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_WEB_NODE
  }
  case object APPIUM_WEB_RUBY extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.APPIUM_WEB_RUBY
  }
  case object CALABASH extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.CALABASH
  }
  case object INSTRUMENTATION extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.INSTRUMENTATION
  }
  case object UIAUTOMATION extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.UIAUTOMATION
  }
  case object UIAUTOMATOR extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.UIAUTOMATOR
  }
  case object XCTEST extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.XCTEST
  }
  case object XCTEST_UI extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.XCTEST_UI
  }
  case object REMOTE_ACCESS_RECORD extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.REMOTE_ACCESS_RECORD
  }
  case object REMOTE_ACCESS_REPLAY extends zio.aws.devicefarm.model.TestType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.TestType =
      software.amazon.awssdk.services.devicefarm.model.TestType.REMOTE_ACCESS_REPLAY
  }
}
