package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TrialMinutes(
    total: Optional[Double] = Optional.Absent,
    remaining: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.TrialMinutes = {
    import TrialMinutes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.TrialMinutes
      .builder()
      .optionallyWith(total.map(value => value: java.lang.Double))(_.total)
      .optionallyWith(remaining.map(value => value: java.lang.Double))(
        _.remaining
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.TrialMinutes.ReadOnly =
    zio.aws.devicefarm.model.TrialMinutes.wrap(buildAwsValue())
}
object TrialMinutes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.TrialMinutes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.TrialMinutes =
      zio.aws.devicefarm.model
        .TrialMinutes(total.map(value => value), remaining.map(value => value))
    def total: Optional[Double]
    def remaining: Optional[Double]
    def getTotal: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("total", total)
    def getRemaining: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("remaining", remaining)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.TrialMinutes
  ) extends zio.aws.devicefarm.model.TrialMinutes.ReadOnly {
    override val total: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => value: Double)
    override val remaining: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.remaining())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.TrialMinutes
  ): zio.aws.devicefarm.model.TrialMinutes.ReadOnly = new Wrapper(impl)
}
