package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDeviceInstanceResponse(
    deviceInstance: Optional[zio.aws.devicefarm.model.DeviceInstance] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceResponse = {
    import UpdateDeviceInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceResponse
      .builder()
      .optionallyWith(deviceInstance.map(value => value.buildAwsValue()))(
        _.deviceInstance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateDeviceInstanceResponse.ReadOnly =
    zio.aws.devicefarm.model.UpdateDeviceInstanceResponse.wrap(buildAwsValue())
}
object UpdateDeviceInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateDeviceInstanceResponse =
      zio.aws.devicefarm.model.UpdateDeviceInstanceResponse(
        deviceInstance.map(value => value.asEditable)
      )
    def deviceInstance
        : Optional[zio.aws.devicefarm.model.DeviceInstance.ReadOnly]
    def getDeviceInstance
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceInstance.ReadOnly] =
      AwsError.unwrapOptionField("deviceInstance", deviceInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceResponse
  ) extends zio.aws.devicefarm.model.UpdateDeviceInstanceResponse.ReadOnly {
    override val deviceInstance
        : Optional[zio.aws.devicefarm.model.DeviceInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceInstance())
        .map(value => zio.aws.devicefarm.model.DeviceInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateDeviceInstanceResponse
  ): zio.aws.devicefarm.model.UpdateDeviceInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
