package zio.aws.devicefarm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  PercentInteger,
  Message,
  Name,
  AmazonResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateNetworkProfileRequest(
    arn: AmazonResourceName,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Message] = Optional.Absent,
    `type`: Optional[zio.aws.devicefarm.model.NetworkProfileType] =
      Optional.Absent,
    uplinkBandwidthBits: Optional[Long] = Optional.Absent,
    downlinkBandwidthBits: Optional[Long] = Optional.Absent,
    uplinkDelayMs: Optional[Long] = Optional.Absent,
    downlinkDelayMs: Optional[Long] = Optional.Absent,
    uplinkJitterMs: Optional[Long] = Optional.Absent,
    downlinkJitterMs: Optional[Long] = Optional.Absent,
    uplinkLossPercent: Optional[PercentInteger] = Optional.Absent,
    downlinkLossPercent: Optional[PercentInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileRequest = {
    import UpdateNetworkProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Message.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(uplinkBandwidthBits.map(value => value: java.lang.Long))(
        _.uplinkBandwidthBits
      )
      .optionallyWith(
        downlinkBandwidthBits.map(value => value: java.lang.Long)
      )(_.downlinkBandwidthBits)
      .optionallyWith(uplinkDelayMs.map(value => value: java.lang.Long))(
        _.uplinkDelayMs
      )
      .optionallyWith(downlinkDelayMs.map(value => value: java.lang.Long))(
        _.downlinkDelayMs
      )
      .optionallyWith(uplinkJitterMs.map(value => value: java.lang.Long))(
        _.uplinkJitterMs
      )
      .optionallyWith(downlinkJitterMs.map(value => value: java.lang.Long))(
        _.downlinkJitterMs
      )
      .optionallyWith(
        uplinkLossPercent.map(value => PercentInteger.unwrap(value): Integer)
      )(_.uplinkLossPercent)
      .optionallyWith(
        downlinkLossPercent.map(value => PercentInteger.unwrap(value): Integer)
      )(_.downlinkLossPercent)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateNetworkProfileRequest.ReadOnly =
    zio.aws.devicefarm.model.UpdateNetworkProfileRequest.wrap(buildAwsValue())
}
object UpdateNetworkProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateNetworkProfileRequest =
      zio.aws.devicefarm.model.UpdateNetworkProfileRequest(
        arn,
        name.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        uplinkBandwidthBits.map(value => value),
        downlinkBandwidthBits.map(value => value),
        uplinkDelayMs.map(value => value),
        downlinkDelayMs.map(value => value),
        uplinkJitterMs.map(value => value),
        downlinkJitterMs.map(value => value),
        uplinkLossPercent.map(value => value),
        downlinkLossPercent.map(value => value)
      )
    def arn: AmazonResourceName
    def name: Optional[Name]
    def description: Optional[Message]
    def `type`: Optional[zio.aws.devicefarm.model.NetworkProfileType]
    def uplinkBandwidthBits: Optional[Long]
    def downlinkBandwidthBits: Optional[Long]
    def uplinkDelayMs: Optional[Long]
    def downlinkDelayMs: Optional[Long]
    def uplinkJitterMs: Optional[Long]
    def downlinkJitterMs: Optional[Long]
    def uplinkLossPercent: Optional[PercentInteger]
    def downlinkLossPercent: Optional[PercentInteger]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("description", description)
    def getType
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.NetworkProfileType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUplinkBandwidthBits: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("uplinkBandwidthBits", uplinkBandwidthBits)
    def getDownlinkBandwidthBits: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("downlinkBandwidthBits", downlinkBandwidthBits)
    def getUplinkDelayMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("uplinkDelayMs", uplinkDelayMs)
    def getDownlinkDelayMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("downlinkDelayMs", downlinkDelayMs)
    def getUplinkJitterMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("uplinkJitterMs", uplinkJitterMs)
    def getDownlinkJitterMs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("downlinkJitterMs", downlinkJitterMs)
    def getUplinkLossPercent: ZIO[Any, AwsError, PercentInteger] =
      AwsError.unwrapOptionField("uplinkLossPercent", uplinkLossPercent)
    def getDownlinkLossPercent: ZIO[Any, AwsError, PercentInteger] =
      AwsError.unwrapOptionField("downlinkLossPercent", downlinkLossPercent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileRequest
  ) extends zio.aws.devicefarm.model.UpdateNetworkProfileRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val description: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
    override val `type`: Optional[zio.aws.devicefarm.model.NetworkProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.devicefarm.model.NetworkProfileType.wrap(value))
    override val uplinkBandwidthBits: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.uplinkBandwidthBits())
      .map(value => value: Long)
    override val downlinkBandwidthBits: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.downlinkBandwidthBits())
      .map(value => value: Long)
    override val uplinkDelayMs: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.uplinkDelayMs())
      .map(value => value: Long)
    override val downlinkDelayMs: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.downlinkDelayMs())
      .map(value => value: Long)
    override val uplinkJitterMs: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.uplinkJitterMs())
      .map(value => value: Long)
    override val downlinkJitterMs: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.downlinkJitterMs())
      .map(value => value: Long)
    override val uplinkLossPercent: Optional[PercentInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uplinkLossPercent())
        .map(value => zio.aws.devicefarm.model.primitives.PercentInteger(value))
    override val downlinkLossPercent: Optional[PercentInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.downlinkLossPercent())
        .map(value => zio.aws.devicefarm.model.primitives.PercentInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateNetworkProfileRequest
  ): zio.aws.devicefarm.model.UpdateNetworkProfileRequest.ReadOnly =
    new Wrapper(impl)
}
