package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateVpceConfigurationResponse(
    vpceConfiguration: Optional[zio.aws.devicefarm.model.VPCEConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationResponse = {
    import UpdateVpceConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationResponse
      .builder()
      .optionallyWith(vpceConfiguration.map(value => value.buildAwsValue()))(
        _.vpceConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.UpdateVpceConfigurationResponse.ReadOnly =
    zio.aws.devicefarm.model.UpdateVpceConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateVpceConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.UpdateVpceConfigurationResponse =
      zio.aws.devicefarm.model.UpdateVpceConfigurationResponse(
        vpceConfiguration.map(value => value.asEditable)
      )
    def vpceConfiguration
        : Optional[zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly]
    def getVpceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpceConfiguration", vpceConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationResponse
  ) extends zio.aws.devicefarm.model.UpdateVpceConfigurationResponse.ReadOnly {
    override val vpceConfiguration
        : Optional[zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpceConfiguration())
        .map(value => zio.aws.devicefarm.model.VPCEConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.UpdateVpceConfigurationResponse
  ): zio.aws.devicefarm.model.UpdateVpceConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
