package zio.aws.devicefarm
import zio.aws.devicefarm.model.UpdateTestGridProjectResponse.ReadOnly
import software.amazon.awssdk.services.devicefarm.{
  DeviceFarmAsyncClientBuilder,
  DeviceFarmAsyncClient
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.devicefarm.paginators.{
  ListUploadsPublisher,
  ListTestsPublisher,
  ListSuitesPublisher,
  ListDevicesPublisher,
  ListArtifactsPublisher,
  ListOfferingsPublisher,
  ListDevicePoolsPublisher,
  ListOfferingTransactionsPublisher,
  ListSamplesPublisher,
  ListRunsPublisher,
  ListProjectsPublisher,
  ListJobsPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.devicefarm.model.{
  UpdateUploadRequest,
  InstallToRemoteAccessSessionRequest,
  GetDeviceInstanceResponse,
  ListUniqueProblemsRequest,
  ListOfferingTransactionsResponse,
  StopRemoteAccessSessionRequest,
  GetTestGridSessionResponse,
  UpdateInstanceProfileRequest,
  ScheduleRunRequest,
  GetDevicePoolRequest,
  CreateVpceConfigurationRequest,
  CreateTestGridProjectResponse,
  StopJobResponse,
  DeleteDevicePoolRequest,
  Offering,
  PurchaseOfferingRequest,
  GetDevicePoolCompatibilityRequest,
  DeleteVpceConfigurationResponse,
  CreateVpceConfigurationResponse,
  ListTestGridProjectsRequest,
  ListDeviceInstancesResponse,
  ListUploadsResponse,
  ListInstanceProfilesRequest,
  CreateTestGridUrlRequest,
  CreateRemoteAccessSessionResponse,
  GetProjectRequest,
  ListTestsResponse,
  DeleteUploadResponse,
  CreateProjectRequest,
  ListTestGridSessionsResponse,
  CreateTestGridProjectRequest,
  GetTestGridSessionRequest,
  ListDevicePoolsResponse,
  ListArtifactsResponse,
  DeleteRemoteAccessSessionResponse,
  GetInstanceProfileRequest,
  CreateInstanceProfileRequest,
  GetTestRequest,
  GetTestGridProjectResponse,
  PurchaseOfferingResponse,
  ListVpceConfigurationsRequest,
  ListOfferingsRequest,
  UpdateTestGridProjectResponse,
  GetRunRequest,
  GetUploadRequest,
  GetSuiteRequest,
  ListProjectsResponse,
  ListJobsRequest,
  DeleteTestGridProjectResponse,
  Test,
  CreateDevicePoolResponse,
  UpdateInstanceProfileResponse,
  ListOfferingPromotionsResponse,
  ListTestsRequest,
  CreateInstanceProfileResponse,
  GetJobRequest,
  StopRemoteAccessSessionResponse,
  InstallToRemoteAccessSessionResponse,
  ListTestGridSessionArtifactsRequest,
  GetDeviceRequest,
  UpdateVpceConfigurationResponse,
  ListDevicesResponse,
  StopRunResponse,
  ListTagsForResourceRequest,
  CreateTestGridUrlResponse,
  UpdateUploadResponse,
  Project,
  ListRunsRequest,
  DeleteNetworkProfileRequest,
  DeleteRunRequest,
  DeleteInstanceProfileRequest,
  CreateDevicePoolRequest,
  GetNetworkProfileResponse,
  ListTestGridSessionActionsResponse,
  GetVpceConfigurationRequest,
  UpdateDevicePoolRequest,
  DeleteTestGridProjectRequest,
  GetDevicePoolCompatibilityResponse,
  ListInstanceProfilesResponse,
  ListOfferingsResponse,
  UpdateNetworkProfileRequest,
  GetJobResponse,
  Upload,
  GetNetworkProfileRequest,
  ListRemoteAccessSessionsRequest,
  UpdateDeviceInstanceResponse,
  DeleteRunResponse,
  UpdateNetworkProfileResponse,
  UpdateProjectRequest,
  ListNetworkProfilesRequest,
  GetTestGridProjectRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  Sample,
  DeleteUploadRequest,
  RenewOfferingResponse,
  GetOfferingStatusRequest,
  DeleteProjectRequest,
  ListArtifactsRequest,
  UpdateDevicePoolResponse,
  GetDeviceResponse,
  Artifact,
  GetDeviceInstanceRequest,
  DeleteVpceConfigurationRequest,
  GetRemoteAccessSessionRequest,
  Suite,
  CreateProjectResponse,
  CreateNetworkProfileResponse,
  GetRemoteAccessSessionResponse,
  Job,
  ListTestGridSessionsRequest,
  ListDeviceInstancesRequest,
  ListSamplesResponse,
  ListTestGridSessionArtifactsResponse,
  ListUniqueProblemsResponse,
  GetInstanceProfileResponse,
  CreateRemoteAccessSessionRequest,
  GetSuiteResponse,
  RenewOfferingRequest,
  GetAccountSettingsResponse,
  ListSuitesResponse,
  UpdateDeviceInstanceRequest,
  DeleteNetworkProfileResponse,
  GetRunResponse,
  UpdateTestGridProjectRequest,
  GetDevicePoolResponse,
  Device,
  ListDevicePoolsRequest,
  ListProjectsRequest,
  DevicePool,
  UntagResourceRequest,
  ListTestGridSessionActionsRequest,
  ListTestGridProjectsResponse,
  DeleteInstanceProfileResponse,
  ListVpceConfigurationsResponse,
  StopRunRequest,
  GetUploadResponse,
  Run,
  CreateUploadResponse,
  ListUploadsRequest,
  ListNetworkProfilesResponse,
  ListOfferingPromotionsRequest,
  GetOfferingStatusResponse,
  ListJobsResponse,
  GetVpceConfigurationResponse,
  ListDevicesRequest,
  GetTestResponse,
  ScheduleRunResponse,
  CreateNetworkProfileRequest,
  ListSuitesRequest,
  CreateUploadRequest,
  ListRemoteAccessSessionsResponse,
  UpdateProjectResponse,
  ListOfferingTransactionsRequest,
  TagResourceResponse,
  OfferingTransaction,
  ListSamplesRequest,
  DeleteProjectResponse,
  UpdateVpceConfigurationRequest,
  GetAccountSettingsRequest,
  DeleteRemoteAccessSessionRequest,
  TagResourceRequest,
  GetProjectResponse,
  DeleteDevicePoolResponse,
  StopJobRequest,
  ListRunsResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait DeviceFarm extends AspectSupport[DeviceFarm] {
  val api: DeviceFarmAsyncClient
  def listTestGridSessionActions(
      request: zio.aws.devicefarm.model.ListTestGridSessionActionsRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.ListTestGridSessionActionsResponse.ReadOnly
  ]
  def listTestGridSessions(
      request: zio.aws.devicefarm.model.ListTestGridSessionsRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.ListTestGridSessionsResponse.ReadOnly
  ]
  def getProject(
      request: zio.aws.devicefarm.model.GetProjectRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetProjectResponse.ReadOnly]
  def updateInstanceProfile(
      request: zio.aws.devicefarm.model.UpdateInstanceProfileRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.UpdateInstanceProfileResponse.ReadOnly
  ]
  def listTestGridProjects(
      request: zio.aws.devicefarm.model.ListTestGridProjectsRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.ListTestGridProjectsResponse.ReadOnly
  ]
  def updateDeviceInstance(
      request: zio.aws.devicefarm.model.UpdateDeviceInstanceRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.UpdateDeviceInstanceResponse.ReadOnly
  ]
  def installToRemoteAccessSession(
      request: zio.aws.devicefarm.model.InstallToRemoteAccessSessionRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse.ReadOnly
  ]
  def updateTestGridProject(
      request: zio.aws.devicefarm.model.UpdateTestGridProjectRequest
  ): IO[AwsError, ReadOnly]
  def updateVPCEConfiguration(
      request: zio.aws.devicefarm.model.UpdateVpceConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.UpdateVpceConfigurationResponse.ReadOnly
  ]
  def getUpload(
      request: zio.aws.devicefarm.model.GetUploadRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetUploadResponse.ReadOnly]
  def updateProject(
      request: zio.aws.devicefarm.model.UpdateProjectRequest
  ): IO[AwsError, zio.aws.devicefarm.model.UpdateProjectResponse.ReadOnly]
  def updateNetworkProfile(
      request: zio.aws.devicefarm.model.UpdateNetworkProfileRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.UpdateNetworkProfileResponse.ReadOnly
  ]
  def updateUpload(
      request: zio.aws.devicefarm.model.UpdateUploadRequest
  ): IO[AwsError, zio.aws.devicefarm.model.UpdateUploadResponse.ReadOnly]
  def createTestGridUrl(
      request: zio.aws.devicefarm.model.CreateTestGridUrlRequest
  ): IO[AwsError, zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly]
  def getRun(
      request: zio.aws.devicefarm.model.GetRunRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetRunResponse.ReadOnly]
  def listDeviceInstances(
      request: zio.aws.devicefarm.model.ListDeviceInstancesRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly]
  def listSuites(
      request: zio.aws.devicefarm.model.ListSuitesRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Suite.ReadOnly]
  def listSuitesPaginated(
      request: zio.aws.devicefarm.model.ListSuitesRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly]
  def deleteRemoteAccessSession(
      request: zio.aws.devicefarm.model.DeleteRemoteAccessSessionRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.DeleteRemoteAccessSessionResponse.ReadOnly
  ]
  def getVPCEConfiguration(
      request: zio.aws.devicefarm.model.GetVpceConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.GetVpceConfigurationResponse.ReadOnly
  ]
  def stopJob(
      request: zio.aws.devicefarm.model.StopJobRequest
  ): IO[AwsError, zio.aws.devicefarm.model.StopJobResponse.ReadOnly]
  def getNetworkProfile(
      request: zio.aws.devicefarm.model.GetNetworkProfileRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetNetworkProfileResponse.ReadOnly]
  def createDevicePool(
      request: zio.aws.devicefarm.model.CreateDevicePoolRequest
  ): IO[AwsError, zio.aws.devicefarm.model.CreateDevicePoolResponse.ReadOnly]
  def listDevices(
      request: zio.aws.devicefarm.model.ListDevicesRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Device.ReadOnly]
  def listDevicesPaginated(
      request: zio.aws.devicefarm.model.ListDevicesRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListDevicesResponse.ReadOnly]
  def getRemoteAccessSession(
      request: zio.aws.devicefarm.model.GetRemoteAccessSessionRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.GetRemoteAccessSessionResponse.ReadOnly
  ]
  def listRemoteAccessSessions(
      request: zio.aws.devicefarm.model.ListRemoteAccessSessionsRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse.ReadOnly
  ]
  def listProjects(
      request: zio.aws.devicefarm.model.ListProjectsRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Project.ReadOnly]
  def listProjectsPaginated(
      request: zio.aws.devicefarm.model.ListProjectsRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListProjectsResponse.ReadOnly]
  def scheduleRun(
      request: zio.aws.devicefarm.model.ScheduleRunRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ScheduleRunResponse.ReadOnly]
  def getDevicePoolCompatibility(
      request: zio.aws.devicefarm.model.GetDevicePoolCompatibilityRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse.ReadOnly
  ]
  def listUploads(
      request: zio.aws.devicefarm.model.ListUploadsRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Upload.ReadOnly]
  def listUploadsPaginated(
      request: zio.aws.devicefarm.model.ListUploadsRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListUploadsResponse.ReadOnly]
  def deleteUpload(
      request: zio.aws.devicefarm.model.DeleteUploadRequest
  ): IO[AwsError, zio.aws.devicefarm.model.DeleteUploadResponse.ReadOnly]
  def listRuns(
      request: zio.aws.devicefarm.model.ListRunsRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Run.ReadOnly]
  def listRunsPaginated(
      request: zio.aws.devicefarm.model.ListRunsRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListRunsResponse.ReadOnly]
  def updateDevicePool(
      request: zio.aws.devicefarm.model.UpdateDevicePoolRequest
  ): IO[AwsError, zio.aws.devicefarm.model.UpdateDevicePoolResponse.ReadOnly]
  def listArtifacts(
      request: zio.aws.devicefarm.model.ListArtifactsRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Artifact.ReadOnly]
  def listArtifactsPaginated(
      request: zio.aws.devicefarm.model.ListArtifactsRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListArtifactsResponse.ReadOnly]
  def getTestGridProject(
      request: zio.aws.devicefarm.model.GetTestGridProjectRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetTestGridProjectResponse.ReadOnly]
  def stopRemoteAccessSession(
      request: zio.aws.devicefarm.model.StopRemoteAccessSessionRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.StopRemoteAccessSessionResponse.ReadOnly
  ]
  def listDevicePools(
      request: zio.aws.devicefarm.model.ListDevicePoolsRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.DevicePool.ReadOnly]
  def listDevicePoolsPaginated(
      request: zio.aws.devicefarm.model.ListDevicePoolsRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListDevicePoolsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.devicefarm.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.devicefarm.model.UntagResourceResponse.ReadOnly]
  def createProject(
      request: zio.aws.devicefarm.model.CreateProjectRequest
  ): IO[AwsError, zio.aws.devicefarm.model.CreateProjectResponse.ReadOnly]
  def createRemoteAccessSession(
      request: zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.CreateRemoteAccessSessionResponse.ReadOnly
  ]
  def stopRun(
      request: zio.aws.devicefarm.model.StopRunRequest
  ): IO[AwsError, zio.aws.devicefarm.model.StopRunResponse.ReadOnly]
  def listUniqueProblems(
      request: zio.aws.devicefarm.model.ListUniqueProblemsRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListUniqueProblemsResponse.ReadOnly]
  def getJob(
      request: zio.aws.devicefarm.model.GetJobRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetJobResponse.ReadOnly]
  def listOfferingTransactions(
      request: zio.aws.devicefarm.model.ListOfferingTransactionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.devicefarm.model.OfferingTransaction.ReadOnly
  ]
  def listOfferingTransactionsPaginated(
      request: zio.aws.devicefarm.model.ListOfferingTransactionsRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly
  ]
  def listOfferings(
      request: zio.aws.devicefarm.model.ListOfferingsRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Offering.ReadOnly]
  def listOfferingsPaginated(
      request: zio.aws.devicefarm.model.ListOfferingsRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListOfferingsResponse.ReadOnly]
  def deleteInstanceProfile(
      request: zio.aws.devicefarm.model.DeleteInstanceProfileRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.DeleteInstanceProfileResponse.ReadOnly
  ]
  def createTestGridProject(
      request: zio.aws.devicefarm.model.CreateTestGridProjectRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.CreateTestGridProjectResponse.ReadOnly
  ]
  def listOfferingPromotions(
      request: zio.aws.devicefarm.model.ListOfferingPromotionsRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly
  ]
  def getSuite(
      request: zio.aws.devicefarm.model.GetSuiteRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetSuiteResponse.ReadOnly]
  def getOfferingStatus(
      request: zio.aws.devicefarm.model.GetOfferingStatusRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly]
  def deleteVPCEConfiguration(
      request: zio.aws.devicefarm.model.DeleteVpceConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.DeleteVpceConfigurationResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.devicefarm.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListTagsForResourceResponse.ReadOnly]
  def listJobs(
      request: zio.aws.devicefarm.model.ListJobsRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Job.ReadOnly]
  def listJobsPaginated(
      request: zio.aws.devicefarm.model.ListJobsRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListJobsResponse.ReadOnly]
  def deleteRun(
      request: zio.aws.devicefarm.model.DeleteRunRequest
  ): IO[AwsError, zio.aws.devicefarm.model.DeleteRunResponse.ReadOnly]
  def deleteDevicePool(
      request: zio.aws.devicefarm.model.DeleteDevicePoolRequest
  ): IO[AwsError, zio.aws.devicefarm.model.DeleteDevicePoolResponse.ReadOnly]
  def getInstanceProfile(
      request: zio.aws.devicefarm.model.GetInstanceProfileRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetInstanceProfileResponse.ReadOnly]
  def tagResource(
      request: zio.aws.devicefarm.model.TagResourceRequest
  ): IO[AwsError, zio.aws.devicefarm.model.TagResourceResponse.ReadOnly]
  def listTests(
      request: zio.aws.devicefarm.model.ListTestsRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Test.ReadOnly]
  def listTestsPaginated(
      request: zio.aws.devicefarm.model.ListTestsRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListTestsResponse.ReadOnly]
  def deleteNetworkProfile(
      request: zio.aws.devicefarm.model.DeleteNetworkProfileRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.DeleteNetworkProfileResponse.ReadOnly
  ]
  def purchaseOffering(
      request: zio.aws.devicefarm.model.PurchaseOfferingRequest
  ): IO[AwsError, zio.aws.devicefarm.model.PurchaseOfferingResponse.ReadOnly]
  def listInstanceProfiles(
      request: zio.aws.devicefarm.model.ListInstanceProfilesRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.ListInstanceProfilesResponse.ReadOnly
  ]
  def getTest(
      request: zio.aws.devicefarm.model.GetTestRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetTestResponse.ReadOnly]
  def listNetworkProfiles(
      request: zio.aws.devicefarm.model.ListNetworkProfilesRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly]
  def getDeviceInstance(
      request: zio.aws.devicefarm.model.GetDeviceInstanceRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetDeviceInstanceResponse.ReadOnly]
  def createInstanceProfile(
      request: zio.aws.devicefarm.model.CreateInstanceProfileRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly
  ]
  def listTestGridSessionArtifacts(
      request: zio.aws.devicefarm.model.ListTestGridSessionArtifactsRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly
  ]
  def deleteTestGridProject(
      request: zio.aws.devicefarm.model.DeleteTestGridProjectRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.DeleteTestGridProjectResponse.ReadOnly
  ]
  def deleteProject(
      request: zio.aws.devicefarm.model.DeleteProjectRequest
  ): IO[AwsError, zio.aws.devicefarm.model.DeleteProjectResponse.ReadOnly]
  def getAccountSettings(
      request: zio.aws.devicefarm.model.GetAccountSettingsRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetAccountSettingsResponse.ReadOnly]
  def createVPCEConfiguration(
      request: zio.aws.devicefarm.model.CreateVpceConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.CreateVpceConfigurationResponse.ReadOnly
  ]
  def getTestGridSession(
      request: zio.aws.devicefarm.model.GetTestGridSessionRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetTestGridSessionResponse.ReadOnly]
  def listVPCEConfigurations(
      request: zio.aws.devicefarm.model.ListVpceConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly
  ]
  def renewOffering(
      request: zio.aws.devicefarm.model.RenewOfferingRequest
  ): IO[AwsError, zio.aws.devicefarm.model.RenewOfferingResponse.ReadOnly]
  def getDevice(
      request: zio.aws.devicefarm.model.GetDeviceRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetDeviceResponse.ReadOnly]
  def createNetworkProfile(
      request: zio.aws.devicefarm.model.CreateNetworkProfileRequest
  ): IO[
    AwsError,
    zio.aws.devicefarm.model.CreateNetworkProfileResponse.ReadOnly
  ]
  def listSamples(
      request: zio.aws.devicefarm.model.ListSamplesRequest
  ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Sample.ReadOnly]
  def listSamplesPaginated(
      request: zio.aws.devicefarm.model.ListSamplesRequest
  ): IO[AwsError, zio.aws.devicefarm.model.ListSamplesResponse.ReadOnly]
  def createUpload(
      request: zio.aws.devicefarm.model.CreateUploadRequest
  ): IO[AwsError, zio.aws.devicefarm.model.CreateUploadResponse.ReadOnly]
  def getDevicePool(
      request: zio.aws.devicefarm.model.GetDevicePoolRequest
  ): IO[AwsError, zio.aws.devicefarm.model.GetDevicePoolResponse.ReadOnly]
}
object DeviceFarm {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DeviceFarm] = customized(
    identity
  )
  def customized(
      customization: DeviceFarmAsyncClientBuilder => DeviceFarmAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DeviceFarm] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DeviceFarmAsyncClientBuilder => DeviceFarmAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, DeviceFarm] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DeviceFarmAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[DeviceFarmAsyncClient, DeviceFarmAsyncClientBuilder](builder);
    b1 <- awsConfig
      .configureHttpClient[DeviceFarmAsyncClient, DeviceFarmAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new DeviceFarmImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DeviceFarmImpl[R](
      override val api: DeviceFarmAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DeviceFarm
      with AwsServiceBase[R] {
    override val serviceName: String = "DeviceFarm"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DeviceFarmImpl[R1] = new DeviceFarmImpl(api, newAspect, r)
    def listTestGridSessionActions(
        request: zio.aws.devicefarm.model.ListTestGridSessionActionsRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListTestGridSessionActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTestGridSessionActionsRequest,
      ListTestGridSessionActionsResponse
    ]("listTestGridSessionActions", api.listTestGridSessionActions)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.ListTestGridSessionActionsResponse.wrap)
      .provideEnvironment(r)
    def listTestGridSessions(
        request: zio.aws.devicefarm.model.ListTestGridSessionsRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListTestGridSessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTestGridSessionsRequest,
      ListTestGridSessionsResponse
    ]("listTestGridSessions", api.listTestGridSessions)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.ListTestGridSessionsResponse.wrap)
      .provideEnvironment(r)
    def getProject(
        request: zio.aws.devicefarm.model.GetProjectRequest
    ): IO[AwsError, zio.aws.devicefarm.model.GetProjectResponse.ReadOnly] =
      asyncRequestResponse[GetProjectRequest, GetProjectResponse](
        "getProject",
        api.getProject
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.GetProjectResponse.wrap)
        .provideEnvironment(r)
    def updateInstanceProfile(
        request: zio.aws.devicefarm.model.UpdateInstanceProfileRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.UpdateInstanceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateInstanceProfileRequest,
      UpdateInstanceProfileResponse
    ]("updateInstanceProfile", api.updateInstanceProfile)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.UpdateInstanceProfileResponse.wrap)
      .provideEnvironment(r)
    def listTestGridProjects(
        request: zio.aws.devicefarm.model.ListTestGridProjectsRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListTestGridProjectsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTestGridProjectsRequest,
      ListTestGridProjectsResponse
    ]("listTestGridProjects", api.listTestGridProjects)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.ListTestGridProjectsResponse.wrap)
      .provideEnvironment(r)
    def updateDeviceInstance(
        request: zio.aws.devicefarm.model.UpdateDeviceInstanceRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.UpdateDeviceInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateDeviceInstanceRequest,
      UpdateDeviceInstanceResponse
    ]("updateDeviceInstance", api.updateDeviceInstance)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.UpdateDeviceInstanceResponse.wrap)
      .provideEnvironment(r)
    def installToRemoteAccessSession(
        request: zio.aws.devicefarm.model.InstallToRemoteAccessSessionRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      InstallToRemoteAccessSessionRequest,
      InstallToRemoteAccessSessionResponse
    ]("installToRemoteAccessSession", api.installToRemoteAccessSession)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse.wrap)
      .provideEnvironment(r)
    def updateTestGridProject(
        request: zio.aws.devicefarm.model.UpdateTestGridProjectRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      UpdateTestGridProjectRequest,
      UpdateTestGridProjectResponse
    ]("updateTestGridProject", api.updateTestGridProject)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.UpdateTestGridProjectResponse.wrap)
      .provideEnvironment(r)
    def updateVPCEConfiguration(
        request: zio.aws.devicefarm.model.UpdateVpceConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.UpdateVpceConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateVpceConfigurationRequest,
      UpdateVpceConfigurationResponse
    ]("updateVPCEConfiguration", api.updateVPCEConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.UpdateVpceConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getUpload(
        request: zio.aws.devicefarm.model.GetUploadRequest
    ): IO[AwsError, zio.aws.devicefarm.model.GetUploadResponse.ReadOnly] =
      asyncRequestResponse[GetUploadRequest, GetUploadResponse](
        "getUpload",
        api.getUpload
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.GetUploadResponse.wrap)
        .provideEnvironment(r)
    def updateProject(
        request: zio.aws.devicefarm.model.UpdateProjectRequest
    ): IO[AwsError, zio.aws.devicefarm.model.UpdateProjectResponse.ReadOnly] =
      asyncRequestResponse[UpdateProjectRequest, UpdateProjectResponse](
        "updateProject",
        api.updateProject
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.UpdateProjectResponse.wrap)
        .provideEnvironment(r)
    def updateNetworkProfile(
        request: zio.aws.devicefarm.model.UpdateNetworkProfileRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.UpdateNetworkProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateNetworkProfileRequest,
      UpdateNetworkProfileResponse
    ]("updateNetworkProfile", api.updateNetworkProfile)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.UpdateNetworkProfileResponse.wrap)
      .provideEnvironment(r)
    def updateUpload(
        request: zio.aws.devicefarm.model.UpdateUploadRequest
    ): IO[AwsError, zio.aws.devicefarm.model.UpdateUploadResponse.ReadOnly] =
      asyncRequestResponse[UpdateUploadRequest, UpdateUploadResponse](
        "updateUpload",
        api.updateUpload
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.UpdateUploadResponse.wrap)
        .provideEnvironment(r)
    def createTestGridUrl(
        request: zio.aws.devicefarm.model.CreateTestGridUrlRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateTestGridUrlRequest, CreateTestGridUrlResponse](
        "createTestGridUrl",
        api.createTestGridUrl
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.CreateTestGridUrlResponse.wrap)
        .provideEnvironment(r)
    def getRun(
        request: zio.aws.devicefarm.model.GetRunRequest
    ): IO[AwsError, zio.aws.devicefarm.model.GetRunResponse.ReadOnly] =
      asyncRequestResponse[GetRunRequest, GetRunResponse]("getRun", api.getRun)(
        request.buildAwsValue()
      ).map(zio.aws.devicefarm.model.GetRunResponse.wrap).provideEnvironment(r)
    def listDeviceInstances(
        request: zio.aws.devicefarm.model.ListDeviceInstancesRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDeviceInstancesRequest,
      ListDeviceInstancesResponse
    ]("listDeviceInstances", api.listDeviceInstances)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.ListDeviceInstancesResponse.wrap)
      .provideEnvironment(r)
    def listSuites(
        request: zio.aws.devicefarm.model.ListSuitesRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Suite.ReadOnly] =
      asyncJavaPaginatedRequest[ListSuitesRequest, Suite, ListSuitesPublisher](
        "listSuites",
        api.listSuitesPaginator,
        _.suites()
      )(request.buildAwsValue())
        .map(item => zio.aws.devicefarm.model.Suite.wrap(item))
        .provideEnvironment(r)
    def listSuitesPaginated(
        request: zio.aws.devicefarm.model.ListSuitesRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly] =
      asyncRequestResponse[ListSuitesRequest, ListSuitesResponse](
        "listSuites",
        api.listSuites
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListSuitesResponse.wrap)
        .provideEnvironment(r)
    def deleteRemoteAccessSession(
        request: zio.aws.devicefarm.model.DeleteRemoteAccessSessionRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.DeleteRemoteAccessSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteRemoteAccessSessionRequest,
      DeleteRemoteAccessSessionResponse
    ]("deleteRemoteAccessSession", api.deleteRemoteAccessSession)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.DeleteRemoteAccessSessionResponse.wrap)
      .provideEnvironment(r)
    def getVPCEConfiguration(
        request: zio.aws.devicefarm.model.GetVpceConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.GetVpceConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetVpceConfigurationRequest,
      GetVpceConfigurationResponse
    ]("getVPCEConfiguration", api.getVPCEConfiguration)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.GetVpceConfigurationResponse.wrap)
      .provideEnvironment(r)
    def stopJob(
        request: zio.aws.devicefarm.model.StopJobRequest
    ): IO[AwsError, zio.aws.devicefarm.model.StopJobResponse.ReadOnly] =
      asyncRequestResponse[StopJobRequest, StopJobResponse](
        "stopJob",
        api.stopJob
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.StopJobResponse.wrap)
        .provideEnvironment(r)
    def getNetworkProfile(
        request: zio.aws.devicefarm.model.GetNetworkProfileRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.GetNetworkProfileResponse.ReadOnly
    ] =
      asyncRequestResponse[GetNetworkProfileRequest, GetNetworkProfileResponse](
        "getNetworkProfile",
        api.getNetworkProfile
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.GetNetworkProfileResponse.wrap)
        .provideEnvironment(r)
    def createDevicePool(
        request: zio.aws.devicefarm.model.CreateDevicePoolRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.CreateDevicePoolResponse.ReadOnly
    ] = asyncRequestResponse[CreateDevicePoolRequest, CreateDevicePoolResponse](
      "createDevicePool",
      api.createDevicePool
    )(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.CreateDevicePoolResponse.wrap)
      .provideEnvironment(r)
    def listDevices(
        request: zio.aws.devicefarm.model.ListDevicesRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Device.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListDevicesRequest,
        Device,
        ListDevicesPublisher
      ]("listDevices", api.listDevicesPaginator, _.devices())(
        request.buildAwsValue()
      ).map(item => zio.aws.devicefarm.model.Device.wrap(item))
        .provideEnvironment(r)
    def listDevicesPaginated(
        request: zio.aws.devicefarm.model.ListDevicesRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListDevicesResponse.ReadOnly] =
      asyncRequestResponse[ListDevicesRequest, ListDevicesResponse](
        "listDevices",
        api.listDevices
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListDevicesResponse.wrap)
        .provideEnvironment(r)
    def getRemoteAccessSession(
        request: zio.aws.devicefarm.model.GetRemoteAccessSessionRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.GetRemoteAccessSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRemoteAccessSessionRequest,
      GetRemoteAccessSessionResponse
    ]("getRemoteAccessSession", api.getRemoteAccessSession)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.GetRemoteAccessSessionResponse.wrap)
      .provideEnvironment(r)
    def listRemoteAccessSessions(
        request: zio.aws.devicefarm.model.ListRemoteAccessSessionsRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRemoteAccessSessionsRequest,
      ListRemoteAccessSessionsResponse
    ]("listRemoteAccessSessions", api.listRemoteAccessSessions)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse.wrap)
      .provideEnvironment(r)
    def listProjects(
        request: zio.aws.devicefarm.model.ListProjectsRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Project.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListProjectsRequest,
        Project,
        ListProjectsPublisher
      ]("listProjects", api.listProjectsPaginator, _.projects())(
        request.buildAwsValue()
      ).map(item => zio.aws.devicefarm.model.Project.wrap(item))
        .provideEnvironment(r)
    def listProjectsPaginated(
        request: zio.aws.devicefarm.model.ListProjectsRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListProjectsResponse.ReadOnly] =
      asyncRequestResponse[ListProjectsRequest, ListProjectsResponse](
        "listProjects",
        api.listProjects
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListProjectsResponse.wrap)
        .provideEnvironment(r)
    def scheduleRun(
        request: zio.aws.devicefarm.model.ScheduleRunRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ScheduleRunResponse.ReadOnly] =
      asyncRequestResponse[ScheduleRunRequest, ScheduleRunResponse](
        "scheduleRun",
        api.scheduleRun
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ScheduleRunResponse.wrap)
        .provideEnvironment(r)
    def getDevicePoolCompatibility(
        request: zio.aws.devicefarm.model.GetDevicePoolCompatibilityRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDevicePoolCompatibilityRequest,
      GetDevicePoolCompatibilityResponse
    ]("getDevicePoolCompatibility", api.getDevicePoolCompatibility)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse.wrap)
      .provideEnvironment(r)
    def listUploads(
        request: zio.aws.devicefarm.model.ListUploadsRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Upload.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListUploadsRequest,
        Upload,
        ListUploadsPublisher
      ]("listUploads", api.listUploadsPaginator, _.uploads())(
        request.buildAwsValue()
      ).map(item => zio.aws.devicefarm.model.Upload.wrap(item))
        .provideEnvironment(r)
    def listUploadsPaginated(
        request: zio.aws.devicefarm.model.ListUploadsRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListUploadsResponse.ReadOnly] =
      asyncRequestResponse[ListUploadsRequest, ListUploadsResponse](
        "listUploads",
        api.listUploads
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListUploadsResponse.wrap)
        .provideEnvironment(r)
    def deleteUpload(
        request: zio.aws.devicefarm.model.DeleteUploadRequest
    ): IO[AwsError, zio.aws.devicefarm.model.DeleteUploadResponse.ReadOnly] =
      asyncRequestResponse[DeleteUploadRequest, DeleteUploadResponse](
        "deleteUpload",
        api.deleteUpload
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.DeleteUploadResponse.wrap)
        .provideEnvironment(r)
    def listRuns(
        request: zio.aws.devicefarm.model.ListRunsRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Run.ReadOnly] =
      asyncJavaPaginatedRequest[ListRunsRequest, Run, ListRunsPublisher](
        "listRuns",
        api.listRunsPaginator,
        _.runs()
      )(request.buildAwsValue())
        .map(item => zio.aws.devicefarm.model.Run.wrap(item))
        .provideEnvironment(r)
    def listRunsPaginated(
        request: zio.aws.devicefarm.model.ListRunsRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListRunsResponse.ReadOnly] =
      asyncRequestResponse[ListRunsRequest, ListRunsResponse](
        "listRuns",
        api.listRuns
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListRunsResponse.wrap)
        .provideEnvironment(r)
    def updateDevicePool(
        request: zio.aws.devicefarm.model.UpdateDevicePoolRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.UpdateDevicePoolResponse.ReadOnly
    ] = asyncRequestResponse[UpdateDevicePoolRequest, UpdateDevicePoolResponse](
      "updateDevicePool",
      api.updateDevicePool
    )(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.UpdateDevicePoolResponse.wrap)
      .provideEnvironment(r)
    def listArtifacts(
        request: zio.aws.devicefarm.model.ListArtifactsRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Artifact.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListArtifactsRequest,
        Artifact,
        ListArtifactsPublisher
      ]("listArtifacts", api.listArtifactsPaginator, _.artifacts())(
        request.buildAwsValue()
      ).map(item => zio.aws.devicefarm.model.Artifact.wrap(item))
        .provideEnvironment(r)
    def listArtifactsPaginated(
        request: zio.aws.devicefarm.model.ListArtifactsRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListArtifactsResponse.ReadOnly] =
      asyncRequestResponse[ListArtifactsRequest, ListArtifactsResponse](
        "listArtifacts",
        api.listArtifacts
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListArtifactsResponse.wrap)
        .provideEnvironment(r)
    def getTestGridProject(
        request: zio.aws.devicefarm.model.GetTestGridProjectRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.GetTestGridProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTestGridProjectRequest,
      GetTestGridProjectResponse
    ]("getTestGridProject", api.getTestGridProject)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.GetTestGridProjectResponse.wrap)
      .provideEnvironment(r)
    def stopRemoteAccessSession(
        request: zio.aws.devicefarm.model.StopRemoteAccessSessionRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.StopRemoteAccessSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      StopRemoteAccessSessionRequest,
      StopRemoteAccessSessionResponse
    ]("stopRemoteAccessSession", api.stopRemoteAccessSession)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.StopRemoteAccessSessionResponse.wrap)
      .provideEnvironment(r)
    def listDevicePools(
        request: zio.aws.devicefarm.model.ListDevicePoolsRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.DevicePool.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListDevicePoolsRequest,
        DevicePool,
        ListDevicePoolsPublisher
      ]("listDevicePools", api.listDevicePoolsPaginator, _.devicePools())(
        request.buildAwsValue()
      ).map(item => zio.aws.devicefarm.model.DevicePool.wrap(item))
        .provideEnvironment(r)
    def listDevicePoolsPaginated(
        request: zio.aws.devicefarm.model.ListDevicePoolsRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListDevicePoolsResponse.ReadOnly] =
      asyncRequestResponse[ListDevicePoolsRequest, ListDevicePoolsResponse](
        "listDevicePools",
        api.listDevicePools
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListDevicePoolsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.devicefarm.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.devicefarm.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createProject(
        request: zio.aws.devicefarm.model.CreateProjectRequest
    ): IO[AwsError, zio.aws.devicefarm.model.CreateProjectResponse.ReadOnly] =
      asyncRequestResponse[CreateProjectRequest, CreateProjectResponse](
        "createProject",
        api.createProject
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.CreateProjectResponse.wrap)
        .provideEnvironment(r)
    def createRemoteAccessSession(
        request: zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.CreateRemoteAccessSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateRemoteAccessSessionRequest,
      CreateRemoteAccessSessionResponse
    ]("createRemoteAccessSession", api.createRemoteAccessSession)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.CreateRemoteAccessSessionResponse.wrap)
      .provideEnvironment(r)
    def stopRun(
        request: zio.aws.devicefarm.model.StopRunRequest
    ): IO[AwsError, zio.aws.devicefarm.model.StopRunResponse.ReadOnly] =
      asyncRequestResponse[StopRunRequest, StopRunResponse](
        "stopRun",
        api.stopRun
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.StopRunResponse.wrap)
        .provideEnvironment(r)
    def listUniqueProblems(
        request: zio.aws.devicefarm.model.ListUniqueProblemsRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListUniqueProblemsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListUniqueProblemsRequest,
      ListUniqueProblemsResponse
    ]("listUniqueProblems", api.listUniqueProblems)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.ListUniqueProblemsResponse.wrap)
      .provideEnvironment(r)
    def getJob(
        request: zio.aws.devicefarm.model.GetJobRequest
    ): IO[AwsError, zio.aws.devicefarm.model.GetJobResponse.ReadOnly] =
      asyncRequestResponse[GetJobRequest, GetJobResponse]("getJob", api.getJob)(
        request.buildAwsValue()
      ).map(zio.aws.devicefarm.model.GetJobResponse.wrap).provideEnvironment(r)
    def listOfferingTransactions(
        request: zio.aws.devicefarm.model.ListOfferingTransactionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.devicefarm.model.OfferingTransaction.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListOfferingTransactionsRequest,
      OfferingTransaction,
      ListOfferingTransactionsPublisher
    ](
      "listOfferingTransactions",
      api.listOfferingTransactionsPaginator,
      _.offeringTransactions()
    )(request.buildAwsValue())
      .map(item => zio.aws.devicefarm.model.OfferingTransaction.wrap(item))
      .provideEnvironment(r)
    def listOfferingTransactionsPaginated(
        request: zio.aws.devicefarm.model.ListOfferingTransactionsRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListOfferingTransactionsRequest,
      ListOfferingTransactionsResponse
    ]("listOfferingTransactions", api.listOfferingTransactions)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.ListOfferingTransactionsResponse.wrap)
      .provideEnvironment(r)
    def listOfferings(
        request: zio.aws.devicefarm.model.ListOfferingsRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Offering.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListOfferingsRequest,
        Offering,
        ListOfferingsPublisher
      ]("listOfferings", api.listOfferingsPaginator, _.offerings())(
        request.buildAwsValue()
      ).map(item => zio.aws.devicefarm.model.Offering.wrap(item))
        .provideEnvironment(r)
    def listOfferingsPaginated(
        request: zio.aws.devicefarm.model.ListOfferingsRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListOfferingsResponse.ReadOnly] =
      asyncRequestResponse[ListOfferingsRequest, ListOfferingsResponse](
        "listOfferings",
        api.listOfferings
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListOfferingsResponse.wrap)
        .provideEnvironment(r)
    def deleteInstanceProfile(
        request: zio.aws.devicefarm.model.DeleteInstanceProfileRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.DeleteInstanceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteInstanceProfileRequest,
      DeleteInstanceProfileResponse
    ]("deleteInstanceProfile", api.deleteInstanceProfile)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.DeleteInstanceProfileResponse.wrap)
      .provideEnvironment(r)
    def createTestGridProject(
        request: zio.aws.devicefarm.model.CreateTestGridProjectRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.CreateTestGridProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTestGridProjectRequest,
      CreateTestGridProjectResponse
    ]("createTestGridProject", api.createTestGridProject)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.CreateTestGridProjectResponse.wrap)
      .provideEnvironment(r)
    def listOfferingPromotions(
        request: zio.aws.devicefarm.model.ListOfferingPromotionsRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListOfferingPromotionsRequest,
      ListOfferingPromotionsResponse
    ]("listOfferingPromotions", api.listOfferingPromotions)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.ListOfferingPromotionsResponse.wrap)
      .provideEnvironment(r)
    def getSuite(
        request: zio.aws.devicefarm.model.GetSuiteRequest
    ): IO[AwsError, zio.aws.devicefarm.model.GetSuiteResponse.ReadOnly] =
      asyncRequestResponse[GetSuiteRequest, GetSuiteResponse](
        "getSuite",
        api.getSuite
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.GetSuiteResponse.wrap)
        .provideEnvironment(r)
    def getOfferingStatus(
        request: zio.aws.devicefarm.model.GetOfferingStatusRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly
    ] =
      asyncRequestResponse[GetOfferingStatusRequest, GetOfferingStatusResponse](
        "getOfferingStatus",
        api.getOfferingStatus
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.GetOfferingStatusResponse.wrap)
        .provideEnvironment(r)
    def deleteVPCEConfiguration(
        request: zio.aws.devicefarm.model.DeleteVpceConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.DeleteVpceConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVpceConfigurationRequest,
      DeleteVpceConfigurationResponse
    ]("deleteVPCEConfiguration", api.deleteVPCEConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.DeleteVpceConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.devicefarm.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listJobs(
        request: zio.aws.devicefarm.model.ListJobsRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Job.ReadOnly] =
      asyncJavaPaginatedRequest[ListJobsRequest, Job, ListJobsPublisher](
        "listJobs",
        api.listJobsPaginator,
        _.jobs()
      )(request.buildAwsValue())
        .map(item => zio.aws.devicefarm.model.Job.wrap(item))
        .provideEnvironment(r)
    def listJobsPaginated(
        request: zio.aws.devicefarm.model.ListJobsRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListJobsResponse.ReadOnly] =
      asyncRequestResponse[ListJobsRequest, ListJobsResponse](
        "listJobs",
        api.listJobs
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListJobsResponse.wrap)
        .provideEnvironment(r)
    def deleteRun(
        request: zio.aws.devicefarm.model.DeleteRunRequest
    ): IO[AwsError, zio.aws.devicefarm.model.DeleteRunResponse.ReadOnly] =
      asyncRequestResponse[DeleteRunRequest, DeleteRunResponse](
        "deleteRun",
        api.deleteRun
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.DeleteRunResponse.wrap)
        .provideEnvironment(r)
    def deleteDevicePool(
        request: zio.aws.devicefarm.model.DeleteDevicePoolRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.DeleteDevicePoolResponse.ReadOnly
    ] = asyncRequestResponse[DeleteDevicePoolRequest, DeleteDevicePoolResponse](
      "deleteDevicePool",
      api.deleteDevicePool
    )(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.DeleteDevicePoolResponse.wrap)
      .provideEnvironment(r)
    def getInstanceProfile(
        request: zio.aws.devicefarm.model.GetInstanceProfileRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.GetInstanceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      GetInstanceProfileRequest,
      GetInstanceProfileResponse
    ]("getInstanceProfile", api.getInstanceProfile)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.GetInstanceProfileResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.devicefarm.model.TagResourceRequest
    ): IO[AwsError, zio.aws.devicefarm.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTests(
        request: zio.aws.devicefarm.model.ListTestsRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Test.ReadOnly] =
      asyncJavaPaginatedRequest[ListTestsRequest, Test, ListTestsPublisher](
        "listTests",
        api.listTestsPaginator,
        _.tests()
      )(request.buildAwsValue())
        .map(item => zio.aws.devicefarm.model.Test.wrap(item))
        .provideEnvironment(r)
    def listTestsPaginated(
        request: zio.aws.devicefarm.model.ListTestsRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListTestsResponse.ReadOnly] =
      asyncRequestResponse[ListTestsRequest, ListTestsResponse](
        "listTests",
        api.listTests
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListTestsResponse.wrap)
        .provideEnvironment(r)
    def deleteNetworkProfile(
        request: zio.aws.devicefarm.model.DeleteNetworkProfileRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.DeleteNetworkProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteNetworkProfileRequest,
      DeleteNetworkProfileResponse
    ]("deleteNetworkProfile", api.deleteNetworkProfile)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.DeleteNetworkProfileResponse.wrap)
      .provideEnvironment(r)
    def purchaseOffering(
        request: zio.aws.devicefarm.model.PurchaseOfferingRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.PurchaseOfferingResponse.ReadOnly
    ] = asyncRequestResponse[PurchaseOfferingRequest, PurchaseOfferingResponse](
      "purchaseOffering",
      api.purchaseOffering
    )(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.PurchaseOfferingResponse.wrap)
      .provideEnvironment(r)
    def listInstanceProfiles(
        request: zio.aws.devicefarm.model.ListInstanceProfilesRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListInstanceProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListInstanceProfilesRequest,
      ListInstanceProfilesResponse
    ]("listInstanceProfiles", api.listInstanceProfiles)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.ListInstanceProfilesResponse.wrap)
      .provideEnvironment(r)
    def getTest(
        request: zio.aws.devicefarm.model.GetTestRequest
    ): IO[AwsError, zio.aws.devicefarm.model.GetTestResponse.ReadOnly] =
      asyncRequestResponse[GetTestRequest, GetTestResponse](
        "getTest",
        api.getTest
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.GetTestResponse.wrap)
        .provideEnvironment(r)
    def listNetworkProfiles(
        request: zio.aws.devicefarm.model.ListNetworkProfilesRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListNetworkProfilesRequest,
      ListNetworkProfilesResponse
    ]("listNetworkProfiles", api.listNetworkProfiles)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.ListNetworkProfilesResponse.wrap)
      .provideEnvironment(r)
    def getDeviceInstance(
        request: zio.aws.devicefarm.model.GetDeviceInstanceRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.GetDeviceInstanceResponse.ReadOnly
    ] =
      asyncRequestResponse[GetDeviceInstanceRequest, GetDeviceInstanceResponse](
        "getDeviceInstance",
        api.getDeviceInstance
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.GetDeviceInstanceResponse.wrap)
        .provideEnvironment(r)
    def createInstanceProfile(
        request: zio.aws.devicefarm.model.CreateInstanceProfileRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateInstanceProfileRequest,
      CreateInstanceProfileResponse
    ]("createInstanceProfile", api.createInstanceProfile)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.CreateInstanceProfileResponse.wrap)
      .provideEnvironment(r)
    def listTestGridSessionArtifacts(
        request: zio.aws.devicefarm.model.ListTestGridSessionArtifactsRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTestGridSessionArtifactsRequest,
      ListTestGridSessionArtifactsResponse
    ]("listTestGridSessionArtifacts", api.listTestGridSessionArtifacts)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.wrap)
      .provideEnvironment(r)
    def deleteTestGridProject(
        request: zio.aws.devicefarm.model.DeleteTestGridProjectRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.DeleteTestGridProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTestGridProjectRequest,
      DeleteTestGridProjectResponse
    ]("deleteTestGridProject", api.deleteTestGridProject)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.DeleteTestGridProjectResponse.wrap)
      .provideEnvironment(r)
    def deleteProject(
        request: zio.aws.devicefarm.model.DeleteProjectRequest
    ): IO[AwsError, zio.aws.devicefarm.model.DeleteProjectResponse.ReadOnly] =
      asyncRequestResponse[DeleteProjectRequest, DeleteProjectResponse](
        "deleteProject",
        api.deleteProject
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.DeleteProjectResponse.wrap)
        .provideEnvironment(r)
    def getAccountSettings(
        request: zio.aws.devicefarm.model.GetAccountSettingsRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.GetAccountSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccountSettingsRequest,
      GetAccountSettingsResponse
    ]("getAccountSettings", api.getAccountSettings)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.GetAccountSettingsResponse.wrap)
      .provideEnvironment(r)
    def createVPCEConfiguration(
        request: zio.aws.devicefarm.model.CreateVpceConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.CreateVpceConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVpceConfigurationRequest,
      CreateVpceConfigurationResponse
    ]("createVPCEConfiguration", api.createVPCEConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.CreateVpceConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getTestGridSession(
        request: zio.aws.devicefarm.model.GetTestGridSessionRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.GetTestGridSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTestGridSessionRequest,
      GetTestGridSessionResponse
    ]("getTestGridSession", api.getTestGridSession)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.GetTestGridSessionResponse.wrap)
      .provideEnvironment(r)
    def listVPCEConfigurations(
        request: zio.aws.devicefarm.model.ListVpceConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVpceConfigurationsRequest,
      ListVpceConfigurationsResponse
    ]("listVPCEConfigurations", api.listVPCEConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.devicefarm.model.ListVpceConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def renewOffering(
        request: zio.aws.devicefarm.model.RenewOfferingRequest
    ): IO[AwsError, zio.aws.devicefarm.model.RenewOfferingResponse.ReadOnly] =
      asyncRequestResponse[RenewOfferingRequest, RenewOfferingResponse](
        "renewOffering",
        api.renewOffering
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.RenewOfferingResponse.wrap)
        .provideEnvironment(r)
    def getDevice(
        request: zio.aws.devicefarm.model.GetDeviceRequest
    ): IO[AwsError, zio.aws.devicefarm.model.GetDeviceResponse.ReadOnly] =
      asyncRequestResponse[GetDeviceRequest, GetDeviceResponse](
        "getDevice",
        api.getDevice
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.GetDeviceResponse.wrap)
        .provideEnvironment(r)
    def createNetworkProfile(
        request: zio.aws.devicefarm.model.CreateNetworkProfileRequest
    ): IO[
      AwsError,
      zio.aws.devicefarm.model.CreateNetworkProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateNetworkProfileRequest,
      CreateNetworkProfileResponse
    ]("createNetworkProfile", api.createNetworkProfile)(request.buildAwsValue())
      .map(zio.aws.devicefarm.model.CreateNetworkProfileResponse.wrap)
      .provideEnvironment(r)
    def listSamples(
        request: zio.aws.devicefarm.model.ListSamplesRequest
    ): ZStream[Any, AwsError, zio.aws.devicefarm.model.Sample.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListSamplesRequest,
        Sample,
        ListSamplesPublisher
      ]("listSamples", api.listSamplesPaginator, _.samples())(
        request.buildAwsValue()
      ).map(item => zio.aws.devicefarm.model.Sample.wrap(item))
        .provideEnvironment(r)
    def listSamplesPaginated(
        request: zio.aws.devicefarm.model.ListSamplesRequest
    ): IO[AwsError, zio.aws.devicefarm.model.ListSamplesResponse.ReadOnly] =
      asyncRequestResponse[ListSamplesRequest, ListSamplesResponse](
        "listSamples",
        api.listSamples
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.ListSamplesResponse.wrap)
        .provideEnvironment(r)
    def createUpload(
        request: zio.aws.devicefarm.model.CreateUploadRequest
    ): IO[AwsError, zio.aws.devicefarm.model.CreateUploadResponse.ReadOnly] =
      asyncRequestResponse[CreateUploadRequest, CreateUploadResponse](
        "createUpload",
        api.createUpload
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.CreateUploadResponse.wrap)
        .provideEnvironment(r)
    def getDevicePool(
        request: zio.aws.devicefarm.model.GetDevicePoolRequest
    ): IO[AwsError, zio.aws.devicefarm.model.GetDevicePoolResponse.ReadOnly] =
      asyncRequestResponse[GetDevicePoolRequest, GetDevicePoolResponse](
        "getDevicePool",
        api.getDevicePool
      )(request.buildAwsValue())
        .map(zio.aws.devicefarm.model.GetDevicePoolResponse.wrap)
        .provideEnvironment(r)
  }
  def listTestGridSessionActions(
      request: zio.aws.devicefarm.model.ListTestGridSessionActionsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListTestGridSessionActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTestGridSessionActions(request))
  def listTestGridSessions(
      request: zio.aws.devicefarm.model.ListTestGridSessionsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListTestGridSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTestGridSessions(request))
  def getProject(request: zio.aws.devicefarm.model.GetProjectRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProject(request))
  def updateInstanceProfile(
      request: zio.aws.devicefarm.model.UpdateInstanceProfileRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.UpdateInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateInstanceProfile(request))
  def listTestGridProjects(
      request: zio.aws.devicefarm.model.ListTestGridProjectsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListTestGridProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTestGridProjects(request))
  def updateDeviceInstance(
      request: zio.aws.devicefarm.model.UpdateDeviceInstanceRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.UpdateDeviceInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDeviceInstance(request))
  def installToRemoteAccessSession(
      request: zio.aws.devicefarm.model.InstallToRemoteAccessSessionRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.InstallToRemoteAccessSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.installToRemoteAccessSession(request))
  def updateTestGridProject(
      request: zio.aws.devicefarm.model.UpdateTestGridProjectRequest
  ): ZIO[zio.aws.devicefarm.DeviceFarm, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateTestGridProject(request))
  def updateVPCEConfiguration(
      request: zio.aws.devicefarm.model.UpdateVpceConfigurationRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.UpdateVpceConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVPCEConfiguration(request))
  def getUpload(request: zio.aws.devicefarm.model.GetUploadRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUpload(request))
  def updateProject(
      request: zio.aws.devicefarm.model.UpdateProjectRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.UpdateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProject(request))
  def updateNetworkProfile(
      request: zio.aws.devicefarm.model.UpdateNetworkProfileRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.UpdateNetworkProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNetworkProfile(request))
  def updateUpload(request: zio.aws.devicefarm.model.UpdateUploadRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.UpdateUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUpload(request))
  def createTestGridUrl(
      request: zio.aws.devicefarm.model.CreateTestGridUrlRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.CreateTestGridUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTestGridUrl(request))
  def getRun(request: zio.aws.devicefarm.model.GetRunRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRun(request))
  def listDeviceInstances(
      request: zio.aws.devicefarm.model.ListDeviceInstancesRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListDeviceInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeviceInstances(request))
  def listSuites(request: zio.aws.devicefarm.model.ListSuitesRequest): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.Suite.ReadOnly
  ] = ZStream.serviceWithStream(_.listSuites(request))
  def listSuitesPaginated(
      request: zio.aws.devicefarm.model.ListSuitesRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSuitesPaginated(request))
  def deleteRemoteAccessSession(
      request: zio.aws.devicefarm.model.DeleteRemoteAccessSessionRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.DeleteRemoteAccessSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRemoteAccessSession(request))
  def getVPCEConfiguration(
      request: zio.aws.devicefarm.model.GetVpceConfigurationRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetVpceConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVPCEConfiguration(request))
  def stopJob(request: zio.aws.devicefarm.model.StopJobRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.StopJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopJob(request))
  def getNetworkProfile(
      request: zio.aws.devicefarm.model.GetNetworkProfileRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetNetworkProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkProfile(request))
  def createDevicePool(
      request: zio.aws.devicefarm.model.CreateDevicePoolRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.CreateDevicePoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDevicePool(request))
  def listDevices(
      request: zio.aws.devicefarm.model.ListDevicesRequest
  ): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.Device.ReadOnly
  ] = ZStream.serviceWithStream(_.listDevices(request))
  def listDevicesPaginated(
      request: zio.aws.devicefarm.model.ListDevicesRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDevicesPaginated(request))
  def getRemoteAccessSession(
      request: zio.aws.devicefarm.model.GetRemoteAccessSessionRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetRemoteAccessSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRemoteAccessSession(request))
  def listRemoteAccessSessions(
      request: zio.aws.devicefarm.model.ListRemoteAccessSessionsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListRemoteAccessSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRemoteAccessSessions(request))
  def listProjects(
      request: zio.aws.devicefarm.model.ListProjectsRequest
  ): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.Project.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjects(request))
  def listProjectsPaginated(
      request: zio.aws.devicefarm.model.ListProjectsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectsPaginated(request))
  def scheduleRun(request: zio.aws.devicefarm.model.ScheduleRunRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ScheduleRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.scheduleRun(request))
  def getDevicePoolCompatibility(
      request: zio.aws.devicefarm.model.GetDevicePoolCompatibilityRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetDevicePoolCompatibilityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevicePoolCompatibility(request))
  def listUploads(
      request: zio.aws.devicefarm.model.ListUploadsRequest
  ): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.Upload.ReadOnly
  ] = ZStream.serviceWithStream(_.listUploads(request))
  def listUploadsPaginated(
      request: zio.aws.devicefarm.model.ListUploadsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListUploadsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUploadsPaginated(request))
  def deleteUpload(request: zio.aws.devicefarm.model.DeleteUploadRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.DeleteUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUpload(request))
  def listRuns(request: zio.aws.devicefarm.model.ListRunsRequest): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.Run.ReadOnly
  ] = ZStream.serviceWithStream(_.listRuns(request))
  def listRunsPaginated(request: zio.aws.devicefarm.model.ListRunsRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListRunsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRunsPaginated(request))
  def updateDevicePool(
      request: zio.aws.devicefarm.model.UpdateDevicePoolRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.UpdateDevicePoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDevicePool(request))
  def listArtifacts(
      request: zio.aws.devicefarm.model.ListArtifactsRequest
  ): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.Artifact.ReadOnly
  ] = ZStream.serviceWithStream(_.listArtifacts(request))
  def listArtifactsPaginated(
      request: zio.aws.devicefarm.model.ListArtifactsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListArtifactsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listArtifactsPaginated(request))
  def getTestGridProject(
      request: zio.aws.devicefarm.model.GetTestGridProjectRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetTestGridProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTestGridProject(request))
  def stopRemoteAccessSession(
      request: zio.aws.devicefarm.model.StopRemoteAccessSessionRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.StopRemoteAccessSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopRemoteAccessSession(request))
  def listDevicePools(
      request: zio.aws.devicefarm.model.ListDevicePoolsRequest
  ): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.DevicePool.ReadOnly
  ] = ZStream.serviceWithStream(_.listDevicePools(request))
  def listDevicePoolsPaginated(
      request: zio.aws.devicefarm.model.ListDevicePoolsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListDevicePoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDevicePoolsPaginated(request))
  def untagResource(
      request: zio.aws.devicefarm.model.UntagResourceRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createProject(
      request: zio.aws.devicefarm.model.CreateProjectRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def createRemoteAccessSession(
      request: zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.CreateRemoteAccessSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRemoteAccessSession(request))
  def stopRun(request: zio.aws.devicefarm.model.StopRunRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.StopRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopRun(request))
  def listUniqueProblems(
      request: zio.aws.devicefarm.model.ListUniqueProblemsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListUniqueProblemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUniqueProblems(request))
  def getJob(request: zio.aws.devicefarm.model.GetJobRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getJob(request))
  def listOfferingTransactions(
      request: zio.aws.devicefarm.model.ListOfferingTransactionsRequest
  ): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.OfferingTransaction.ReadOnly
  ] = ZStream.serviceWithStream(_.listOfferingTransactions(request))
  def listOfferingTransactionsPaginated(
      request: zio.aws.devicefarm.model.ListOfferingTransactionsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListOfferingTransactionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOfferingTransactionsPaginated(request))
  def listOfferings(
      request: zio.aws.devicefarm.model.ListOfferingsRequest
  ): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.Offering.ReadOnly
  ] = ZStream.serviceWithStream(_.listOfferings(request))
  def listOfferingsPaginated(
      request: zio.aws.devicefarm.model.ListOfferingsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOfferingsPaginated(request))
  def deleteInstanceProfile(
      request: zio.aws.devicefarm.model.DeleteInstanceProfileRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.DeleteInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInstanceProfile(request))
  def createTestGridProject(
      request: zio.aws.devicefarm.model.CreateTestGridProjectRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.CreateTestGridProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTestGridProject(request))
  def listOfferingPromotions(
      request: zio.aws.devicefarm.model.ListOfferingPromotionsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListOfferingPromotionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOfferingPromotions(request))
  def getSuite(request: zio.aws.devicefarm.model.GetSuiteRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetSuiteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSuite(request))
  def getOfferingStatus(
      request: zio.aws.devicefarm.model.GetOfferingStatusRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOfferingStatus(request))
  def deleteVPCEConfiguration(
      request: zio.aws.devicefarm.model.DeleteVpceConfigurationRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.DeleteVpceConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVPCEConfiguration(request))
  def listTagsForResource(
      request: zio.aws.devicefarm.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listJobs(request: zio.aws.devicefarm.model.ListJobsRequest): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.Job.ReadOnly
  ] = ZStream.serviceWithStream(_.listJobs(request))
  def listJobsPaginated(request: zio.aws.devicefarm.model.ListJobsRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listJobsPaginated(request))
  def deleteRun(request: zio.aws.devicefarm.model.DeleteRunRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.DeleteRunResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRun(request))
  def deleteDevicePool(
      request: zio.aws.devicefarm.model.DeleteDevicePoolRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.DeleteDevicePoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDevicePool(request))
  def getInstanceProfile(
      request: zio.aws.devicefarm.model.GetInstanceProfileRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInstanceProfile(request))
  def tagResource(request: zio.aws.devicefarm.model.TagResourceRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listTests(request: zio.aws.devicefarm.model.ListTestsRequest): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.Test.ReadOnly
  ] = ZStream.serviceWithStream(_.listTests(request))
  def listTestsPaginated(
      request: zio.aws.devicefarm.model.ListTestsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListTestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTestsPaginated(request))
  def deleteNetworkProfile(
      request: zio.aws.devicefarm.model.DeleteNetworkProfileRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.DeleteNetworkProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNetworkProfile(request))
  def purchaseOffering(
      request: zio.aws.devicefarm.model.PurchaseOfferingRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.PurchaseOfferingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.purchaseOffering(request))
  def listInstanceProfiles(
      request: zio.aws.devicefarm.model.ListInstanceProfilesRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListInstanceProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listInstanceProfiles(request))
  def getTest(request: zio.aws.devicefarm.model.GetTestRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetTestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTest(request))
  def listNetworkProfiles(
      request: zio.aws.devicefarm.model.ListNetworkProfilesRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListNetworkProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNetworkProfiles(request))
  def getDeviceInstance(
      request: zio.aws.devicefarm.model.GetDeviceInstanceRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetDeviceInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeviceInstance(request))
  def createInstanceProfile(
      request: zio.aws.devicefarm.model.CreateInstanceProfileRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.CreateInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInstanceProfile(request))
  def listTestGridSessionArtifacts(
      request: zio.aws.devicefarm.model.ListTestGridSessionArtifactsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTestGridSessionArtifacts(request))
  def deleteTestGridProject(
      request: zio.aws.devicefarm.model.DeleteTestGridProjectRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.DeleteTestGridProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTestGridProject(request))
  def deleteProject(
      request: zio.aws.devicefarm.model.DeleteProjectRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
  def getAccountSettings(
      request: zio.aws.devicefarm.model.GetAccountSettingsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetAccountSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountSettings(request))
  def createVPCEConfiguration(
      request: zio.aws.devicefarm.model.CreateVpceConfigurationRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.CreateVpceConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVPCEConfiguration(request))
  def getTestGridSession(
      request: zio.aws.devicefarm.model.GetTestGridSessionRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetTestGridSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTestGridSession(request))
  def listVPCEConfigurations(
      request: zio.aws.devicefarm.model.ListVpceConfigurationsRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListVpceConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVPCEConfigurations(request))
  def renewOffering(
      request: zio.aws.devicefarm.model.RenewOfferingRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.RenewOfferingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.renewOffering(request))
  def getDevice(request: zio.aws.devicefarm.model.GetDeviceRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevice(request))
  def createNetworkProfile(
      request: zio.aws.devicefarm.model.CreateNetworkProfileRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.CreateNetworkProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetworkProfile(request))
  def listSamples(
      request: zio.aws.devicefarm.model.ListSamplesRequest
  ): ZStream[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.Sample.ReadOnly
  ] = ZStream.serviceWithStream(_.listSamples(request))
  def listSamplesPaginated(
      request: zio.aws.devicefarm.model.ListSamplesRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.ListSamplesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSamplesPaginated(request))
  def createUpload(request: zio.aws.devicefarm.model.CreateUploadRequest): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.CreateUploadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUpload(request))
  def getDevicePool(
      request: zio.aws.devicefarm.model.GetDevicePoolRequest
  ): ZIO[
    zio.aws.devicefarm.DeviceFarm,
    AwsError,
    zio.aws.devicefarm.model.GetDevicePoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevicePool(request))
}
