package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  SkipAppResign,
  JobTimeoutMinutes,
  Integer,
  AWSAccountNumber
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AccountSettings(
    awsAccountNumber: Optional[AWSAccountNumber] = Optional.Absent,
    unmeteredDevices: Optional[
      Map[zio.aws.devicefarm.model.DevicePlatform, Integer]
    ] = Optional.Absent,
    unmeteredRemoteAccessDevices: Optional[
      Map[zio.aws.devicefarm.model.DevicePlatform, Integer]
    ] = Optional.Absent,
    maxJobTimeoutMinutes: Optional[JobTimeoutMinutes] = Optional.Absent,
    trialMinutes: Optional[zio.aws.devicefarm.model.TrialMinutes] =
      Optional.Absent,
    maxSlots: Optional[Map[String, Integer]] = Optional.Absent,
    defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes] = Optional.Absent,
    skipAppResign: Optional[SkipAppResign] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.AccountSettings = {
    import AccountSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.AccountSettings
      .builder()
      .optionallyWith(
        awsAccountNumber.map(value =>
          AWSAccountNumber.unwrap(value): java.lang.String
        )
      )(_.awsAccountNumber)
      .optionallyWith(
        unmeteredDevices.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.Integer)
            })
            .asJava
        )
      )(_.unmeteredDevicesWithStrings)
      .optionallyWith(
        unmeteredRemoteAccessDevices.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.Integer)
            })
            .asJava
        )
      )(_.unmeteredRemoteAccessDevicesWithStrings)
      .optionallyWith(
        maxJobTimeoutMinutes.map(value =>
          JobTimeoutMinutes.unwrap(value): java.lang.Integer
        )
      )(_.maxJobTimeoutMinutes)
      .optionallyWith(trialMinutes.map(value => value.buildAwsValue()))(
        _.trialMinutes
      )
      .optionallyWith(
        maxSlots.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.Integer)
            })
            .asJava
        )
      )(_.maxSlots)
      .optionallyWith(
        defaultJobTimeoutMinutes.map(value =>
          JobTimeoutMinutes.unwrap(value): java.lang.Integer
        )
      )(_.defaultJobTimeoutMinutes)
      .optionallyWith(
        skipAppResign.map(value =>
          SkipAppResign.unwrap(value): java.lang.Boolean
        )
      )(_.skipAppResign)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.AccountSettings.ReadOnly =
    zio.aws.devicefarm.model.AccountSettings.wrap(buildAwsValue())
}
object AccountSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.AccountSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.AccountSettings =
      zio.aws.devicefarm.model.AccountSettings(
        awsAccountNumber.map(value => value),
        unmeteredDevices.map(value => value),
        unmeteredRemoteAccessDevices.map(value => value),
        maxJobTimeoutMinutes.map(value => value),
        trialMinutes.map(value => value.asEditable),
        maxSlots.map(value => value),
        defaultJobTimeoutMinutes.map(value => value),
        skipAppResign.map(value => value)
      )
    def awsAccountNumber: Optional[AWSAccountNumber]
    def unmeteredDevices
        : Optional[Map[zio.aws.devicefarm.model.DevicePlatform, Integer]]
    def unmeteredRemoteAccessDevices
        : Optional[Map[zio.aws.devicefarm.model.DevicePlatform, Integer]]
    def maxJobTimeoutMinutes: Optional[JobTimeoutMinutes]
    def trialMinutes: Optional[zio.aws.devicefarm.model.TrialMinutes.ReadOnly]
    def maxSlots: Optional[Map[String, Integer]]
    def defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes]
    def skipAppResign: Optional[SkipAppResign]
    def getAwsAccountNumber: ZIO[Any, AwsError, AWSAccountNumber] =
      AwsError.unwrapOptionField("awsAccountNumber", awsAccountNumber)
    def getUnmeteredDevices: ZIO[Any, AwsError, Map[
      zio.aws.devicefarm.model.DevicePlatform,
      Integer
    ]] = AwsError.unwrapOptionField("unmeteredDevices", unmeteredDevices)
    def getUnmeteredRemoteAccessDevices: ZIO[Any, AwsError, Map[
      zio.aws.devicefarm.model.DevicePlatform,
      Integer
    ]] = AwsError.unwrapOptionField(
      "unmeteredRemoteAccessDevices",
      unmeteredRemoteAccessDevices
    )
    def getMaxJobTimeoutMinutes: ZIO[Any, AwsError, JobTimeoutMinutes] =
      AwsError.unwrapOptionField("maxJobTimeoutMinutes", maxJobTimeoutMinutes)
    def getTrialMinutes
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.TrialMinutes.ReadOnly] =
      AwsError.unwrapOptionField("trialMinutes", trialMinutes)
    def getMaxSlots: ZIO[Any, AwsError, Map[String, Integer]] =
      AwsError.unwrapOptionField("maxSlots", maxSlots)
    def getDefaultJobTimeoutMinutes: ZIO[Any, AwsError, JobTimeoutMinutes] =
      AwsError.unwrapOptionField(
        "defaultJobTimeoutMinutes",
        defaultJobTimeoutMinutes
      )
    def getSkipAppResign: ZIO[Any, AwsError, SkipAppResign] =
      AwsError.unwrapOptionField("skipAppResign", skipAppResign)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.AccountSettings
  ) extends zio.aws.devicefarm.model.AccountSettings.ReadOnly {
    override val awsAccountNumber: Optional[AWSAccountNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsAccountNumber())
        .map(value =>
          zio.aws.devicefarm.model.primitives.AWSAccountNumber(value)
        )
    override val unmeteredDevices
        : Optional[Map[zio.aws.devicefarm.model.DevicePlatform, Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unmeteredDevices())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.devicefarm.model.DevicePlatform
                .wrap(key) -> (value: Integer)
            })
            .toMap
        )
    override val unmeteredRemoteAccessDevices
        : Optional[Map[zio.aws.devicefarm.model.DevicePlatform, Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unmeteredRemoteAccessDevices())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.devicefarm.model.DevicePlatform
                .wrap(key) -> (value: Integer)
            })
            .toMap
        )
    override val maxJobTimeoutMinutes: Optional[JobTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxJobTimeoutMinutes())
        .map(value =>
          zio.aws.devicefarm.model.primitives.JobTimeoutMinutes(value)
        )
    override val trialMinutes
        : Optional[zio.aws.devicefarm.model.TrialMinutes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialMinutes())
        .map(value => zio.aws.devicefarm.model.TrialMinutes.wrap(value))
    override val maxSlots: Optional[Map[String, Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxSlots())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: Integer)
            })
            .toMap
        )
    override val defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultJobTimeoutMinutes())
        .map(value =>
          zio.aws.devicefarm.model.primitives.JobTimeoutMinutes(value)
        )
    override val skipAppResign: Optional[SkipAppResign] = zio.aws.core.internal
      .optionalFromNullable(impl.skipAppResign())
      .map(value => zio.aws.devicefarm.model.primitives.SkipAppResign(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.AccountSettings
  ): zio.aws.devicefarm.model.AccountSettings.ReadOnly = new Wrapper(impl)
}
