package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait ArtifactCategory {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.ArtifactCategory
}
object ArtifactCategory {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.ArtifactCategory
  ): zio.aws.devicefarm.model.ArtifactCategory = value match {
    case software.amazon.awssdk.services.devicefarm.model.ArtifactCategory.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactCategory.SCREENSHOT =>
      val r = SCREENSHOT
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactCategory.FILE =>
      val r = FILE
      r
    case software.amazon.awssdk.services.devicefarm.model.ArtifactCategory.LOG =>
      val r = LOG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.ArtifactCategory {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactCategory =
      software.amazon.awssdk.services.devicefarm.model.ArtifactCategory.UNKNOWN_TO_SDK_VERSION
  }
  case object SCREENSHOT extends zio.aws.devicefarm.model.ArtifactCategory {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactCategory =
      software.amazon.awssdk.services.devicefarm.model.ArtifactCategory.SCREENSHOT
  }
  case object FILE extends zio.aws.devicefarm.model.ArtifactCategory {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactCategory =
      software.amazon.awssdk.services.devicefarm.model.ArtifactCategory.FILE
  }
  case object LOG extends zio.aws.devicefarm.model.ArtifactCategory {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.ArtifactCategory =
      software.amazon.awssdk.services.devicefarm.model.ArtifactCategory.LOG
  }
}
