package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait BillingMethod {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.BillingMethod
}
object BillingMethod {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.BillingMethod
  ): zio.aws.devicefarm.model.BillingMethod = value match {
    case software.amazon.awssdk.services.devicefarm.model.BillingMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.BillingMethod.METERED =>
      val r = METERED
      r
    case software.amazon.awssdk.services.devicefarm.model.BillingMethod.UNMETERED =>
      val r = UNMETERED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.BillingMethod {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.BillingMethod =
      software.amazon.awssdk.services.devicefarm.model.BillingMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object METERED extends zio.aws.devicefarm.model.BillingMethod {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.BillingMethod =
      software.amazon.awssdk.services.devicefarm.model.BillingMethod.METERED
  }
  case object UNMETERED extends zio.aws.devicefarm.model.BillingMethod {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.BillingMethod =
      software.amazon.awssdk.services.devicefarm.model.BillingMethod.UNMETERED
  }
}
