package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{
  ClientId,
  Name,
  SshPublicKey,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateRemoteAccessSessionRequest(
    projectArn: AmazonResourceName,
    deviceArn: AmazonResourceName,
    instanceArn: Optional[AmazonResourceName] = Optional.Absent,
    sshPublicKey: Optional[SshPublicKey] = Optional.Absent,
    remoteDebugEnabled: Optional[Boolean] = Optional.Absent,
    remoteRecordEnabled: Optional[Boolean] = Optional.Absent,
    remoteRecordAppArn: Optional[AmazonResourceName] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    clientId: Optional[ClientId] = Optional.Absent,
    configuration: Optional[
      zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration
    ] = Optional.Absent,
    interactionMode: Optional[zio.aws.devicefarm.model.InteractionMode] =
      Optional.Absent,
    skipAppResign: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest = {
    import CreateRemoteAccessSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest
      .builder()
      .projectArn(AmazonResourceName.unwrap(projectArn): java.lang.String)
      .deviceArn(AmazonResourceName.unwrap(deviceArn): java.lang.String)
      .optionallyWith(
        instanceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.instanceArn)
      .optionallyWith(
        sshPublicKey.map(value => SshPublicKey.unwrap(value): java.lang.String)
      )(_.sshPublicKey)
      .optionallyWith(
        remoteDebugEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteDebugEnabled)
      .optionallyWith(
        remoteRecordEnabled.map(value => value: java.lang.Boolean)
      )(_.remoteRecordEnabled)
      .optionallyWith(
        remoteRecordAppArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.remoteRecordAppArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(interactionMode.map(value => value.unwrap))(
        _.interactionMode
      )
      .optionallyWith(skipAppResign.map(value => value: java.lang.Boolean))(
        _.skipAppResign
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest.ReadOnly =
    zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest
      .wrap(buildAwsValue())
}
object CreateRemoteAccessSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest =
      zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest(
        projectArn,
        deviceArn,
        instanceArn.map(value => value),
        sshPublicKey.map(value => value),
        remoteDebugEnabled.map(value => value),
        remoteRecordEnabled.map(value => value),
        remoteRecordAppArn.map(value => value),
        name.map(value => value),
        clientId.map(value => value),
        configuration.map(value => value.asEditable),
        interactionMode.map(value => value),
        skipAppResign.map(value => value)
      )
    def projectArn: AmazonResourceName
    def deviceArn: AmazonResourceName
    def instanceArn: Optional[AmazonResourceName]
    def sshPublicKey: Optional[SshPublicKey]
    def remoteDebugEnabled: Optional[Boolean]
    def remoteRecordEnabled: Optional[Boolean]
    def remoteRecordAppArn: Optional[AmazonResourceName]
    def name: Optional[Name]
    def clientId: Optional[ClientId]
    def configuration: Optional[
      zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration.ReadOnly
    ]
    def interactionMode: Optional[zio.aws.devicefarm.model.InteractionMode]
    def skipAppResign: Optional[Boolean]
    def getProjectArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(projectArn)
    def getDeviceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(deviceArn)
    def getInstanceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("instanceArn", instanceArn)
    def getSshPublicKey: ZIO[Any, AwsError, SshPublicKey] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
    def getRemoteDebugEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteDebugEnabled", remoteDebugEnabled)
    def getRemoteRecordEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("remoteRecordEnabled", remoteRecordEnabled)
    def getRemoteRecordAppArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("remoteRecordAppArn", remoteRecordAppArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getInteractionMode
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.InteractionMode] =
      AwsError.unwrapOptionField("interactionMode", interactionMode)
    def getSkipAppResign: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("skipAppResign", skipAppResign)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest
  ) extends zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest.ReadOnly {
    override val projectArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.projectArn())
    override val deviceArn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.deviceArn())
    override val instanceArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceArn())
        .map(value =>
          zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
        )
    override val sshPublicKey: Optional[SshPublicKey] = zio.aws.core.internal
      .optionalFromNullable(impl.sshPublicKey())
      .map(value => zio.aws.devicefarm.model.primitives.SshPublicKey(value))
    override val remoteDebugEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteDebugEnabled())
      .map(value => value: Boolean)
    override val remoteRecordEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteRecordEnabled())
      .map(value => value: Boolean)
    override val remoteRecordAppArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteRecordAppArn())
        .map(value =>
          zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
        )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val clientId: Optional[ClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => zio.aws.devicefarm.model.primitives.ClientId(value))
    override val configuration: Optional[
      zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        zio.aws.devicefarm.model.CreateRemoteAccessSessionConfiguration
          .wrap(value)
      )
    override val interactionMode
        : Optional[zio.aws.devicefarm.model.InteractionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interactionMode())
        .map(value => zio.aws.devicefarm.model.InteractionMode.wrap(value))
    override val skipAppResign: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.skipAppResign())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateRemoteAccessSessionRequest
  ): zio.aws.devicefarm.model.CreateRemoteAccessSessionRequest.ReadOnly =
    new Wrapper(impl)
}
