package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateVpceConfigurationResponse(
    vpceConfiguration: Optional[zio.aws.devicefarm.model.VPCEConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationResponse = {
    import CreateVpceConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationResponse
      .builder()
      .optionallyWith(vpceConfiguration.map(value => value.buildAwsValue()))(
        _.vpceConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.CreateVpceConfigurationResponse.ReadOnly =
    zio.aws.devicefarm.model.CreateVpceConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateVpceConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CreateVpceConfigurationResponse =
      zio.aws.devicefarm.model.CreateVpceConfigurationResponse(
        vpceConfiguration.map(value => value.asEditable)
      )
    def vpceConfiguration
        : Optional[zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly]
    def getVpceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpceConfiguration", vpceConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationResponse
  ) extends zio.aws.devicefarm.model.CreateVpceConfigurationResponse.ReadOnly {
    override val vpceConfiguration
        : Optional[zio.aws.devicefarm.model.VPCEConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpceConfiguration())
        .map(value => zio.aws.devicefarm.model.VPCEConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CreateVpceConfigurationResponse
  ): zio.aws.devicefarm.model.CreateVpceConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
