package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomerArtifactPaths(
    iosPaths: Optional[Iterable[String]] = Optional.Absent,
    androidPaths: Optional[Iterable[String]] = Optional.Absent,
    deviceHostPaths: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths = {
    import CustomerArtifactPaths.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths
      .builder()
      .optionallyWith(
        iosPaths.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.iosPaths)
      .optionallyWith(
        androidPaths.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.androidPaths)
      .optionallyWith(
        deviceHostPaths.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.deviceHostPaths)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly =
    zio.aws.devicefarm.model.CustomerArtifactPaths.wrap(buildAwsValue())
}
object CustomerArtifactPaths {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.CustomerArtifactPaths =
      zio.aws.devicefarm.model.CustomerArtifactPaths(
        iosPaths.map(value => value),
        androidPaths.map(value => value),
        deviceHostPaths.map(value => value)
      )
    def iosPaths: Optional[List[String]]
    def androidPaths: Optional[List[String]]
    def deviceHostPaths: Optional[List[String]]
    def getIosPaths: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("iosPaths", iosPaths)
    def getAndroidPaths: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("androidPaths", androidPaths)
    def getDeviceHostPaths: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("deviceHostPaths", deviceHostPaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths
  ) extends zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly {
    override val iosPaths: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.iosPaths())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val androidPaths: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.androidPaths())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val deviceHostPaths: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceHostPaths())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.CustomerArtifactPaths
  ): zio.aws.devicefarm.model.CustomerArtifactPaths.ReadOnly = new Wrapper(impl)
}
