package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceAttribute {
  def unwrap: software.amazon.awssdk.services.devicefarm.model.DeviceAttribute
}
object DeviceAttribute {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.DeviceAttribute
  ): zio.aws.devicefarm.model.DeviceAttribute = value match {
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.ARN =>
      val r = ARN
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.PLATFORM =>
      val r = PLATFORM
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.FORM_FACTOR =>
      val r = FORM_FACTOR
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.MANUFACTURER =>
      val r = MANUFACTURER
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.REMOTE_ACCESS_ENABLED =>
      val r = REMOTE_ACCESS_ENABLED
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.REMOTE_DEBUG_ENABLED =>
      val r = REMOTE_DEBUG_ENABLED
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.APPIUM_VERSION =>
      val r = APPIUM_VERSION
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.INSTANCE_ARN =>
      val r = INSTANCE_ARN
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.INSTANCE_LABELS =>
      val r = INSTANCE_LABELS
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.FLEET_TYPE =>
      val r = FLEET_TYPE
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.OS_VERSION =>
      val r = OS_VERSION
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.MODEL =>
      val r = MODEL
      r
    case software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.AVAILABILITY =>
      val r = AVAILABILITY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object ARN extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.ARN
  }
  case object PLATFORM extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.PLATFORM
  }
  case object FORM_FACTOR extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.FORM_FACTOR
  }
  case object MANUFACTURER extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.MANUFACTURER
  }
  case object REMOTE_ACCESS_ENABLED
      extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.REMOTE_ACCESS_ENABLED
  }
  case object REMOTE_DEBUG_ENABLED
      extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.REMOTE_DEBUG_ENABLED
  }
  case object APPIUM_VERSION extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.APPIUM_VERSION
  }
  case object INSTANCE_ARN extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.INSTANCE_ARN
  }
  case object INSTANCE_LABELS extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.INSTANCE_LABELS
  }
  case object FLEET_TYPE extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.FLEET_TYPE
  }
  case object OS_VERSION extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.OS_VERSION
  }
  case object MODEL extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.MODEL
  }
  case object AVAILABILITY extends zio.aws.devicefarm.model.DeviceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.DeviceAttribute =
      software.amazon.awssdk.services.devicefarm.model.DeviceAttribute.AVAILABILITY
  }
}
