package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeviceInstance(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    deviceArn: Optional[AmazonResourceName] = Optional.Absent,
    labels: Optional[Iterable[String]] = Optional.Absent,
    status: Optional[zio.aws.devicefarm.model.InstanceStatus] = Optional.Absent,
    udid: Optional[String] = Optional.Absent,
    instanceProfile: Optional[zio.aws.devicefarm.model.InstanceProfile] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeviceInstance = {
    import DeviceInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeviceInstance
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        deviceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.deviceArn)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(udid.map(value => value: java.lang.String))(_.udid)
      .optionallyWith(instanceProfile.map(value => value.buildAwsValue()))(
        _.instanceProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.DeviceInstance.ReadOnly =
    zio.aws.devicefarm.model.DeviceInstance.wrap(buildAwsValue())
}
object DeviceInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeviceInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeviceInstance =
      zio.aws.devicefarm.model.DeviceInstance(
        arn.map(value => value),
        deviceArn.map(value => value),
        labels.map(value => value),
        status.map(value => value),
        udid.map(value => value),
        instanceProfile.map(value => value.asEditable)
      )
    def arn: Optional[AmazonResourceName]
    def deviceArn: Optional[AmazonResourceName]
    def labels: Optional[List[String]]
    def status: Optional[zio.aws.devicefarm.model.InstanceStatus]
    def udid: Optional[String]
    def instanceProfile
        : Optional[zio.aws.devicefarm.model.InstanceProfile.ReadOnly]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getDeviceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getLabels: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("labels", labels)
    def getStatus: ZIO[Any, AwsError, zio.aws.devicefarm.model.InstanceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUdid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("udid", udid)
    def getInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.devicefarm.model.InstanceProfile.ReadOnly
    ] = AwsError.unwrapOptionField("instanceProfile", instanceProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceInstance
  ) extends zio.aws.devicefarm.model.DeviceInstance.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val deviceArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceArn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val labels: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: Optional[zio.aws.devicefarm.model.InstanceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.devicefarm.model.InstanceStatus.wrap(value))
    override val udid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.udid())
      .map(value => value: String)
    override val instanceProfile
        : Optional[zio.aws.devicefarm.model.InstanceProfile.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceProfile())
        .map(value => zio.aws.devicefarm.model.InstanceProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceInstance
  ): zio.aws.devicefarm.model.DeviceInstance.ReadOnly = new Wrapper(impl)
}
