package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeviceSelectionConfiguration(
    filters: Iterable[zio.aws.devicefarm.model.DeviceFilter],
    maxDevices: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.DeviceSelectionConfiguration = {
    import DeviceSelectionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.DeviceSelectionConfiguration
      .builder()
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .maxDevices(maxDevices: java.lang.Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.DeviceSelectionConfiguration.ReadOnly =
    zio.aws.devicefarm.model.DeviceSelectionConfiguration.wrap(buildAwsValue())
}
object DeviceSelectionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.DeviceSelectionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.DeviceSelectionConfiguration =
      zio.aws.devicefarm.model.DeviceSelectionConfiguration(
        filters.map { item =>
          item.asEditable
        },
        maxDevices
      )
    def filters: List[zio.aws.devicefarm.model.DeviceFilter.ReadOnly]
    def maxDevices: Integer
    def getFilters: ZIO[Any, Nothing, List[
      zio.aws.devicefarm.model.DeviceFilter.ReadOnly
    ]] = ZIO.succeed(filters)
    def getMaxDevices: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxDevices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceSelectionConfiguration
  ) extends zio.aws.devicefarm.model.DeviceSelectionConfiguration.ReadOnly {
    override val filters: List[zio.aws.devicefarm.model.DeviceFilter.ReadOnly] =
      impl
        .filters()
        .asScala
        .map { item =>
          zio.aws.devicefarm.model.DeviceFilter.wrap(item)
        }
        .toList
    override val maxDevices: Integer = impl.maxDevices(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.DeviceSelectionConfiguration
  ): zio.aws.devicefarm.model.DeviceSelectionConfiguration.ReadOnly =
    new Wrapper(impl)
}
