package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, OfferingIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetOfferingStatusResponse(
    current: Optional[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus]
    ] = Optional.Absent,
    nextPeriod: Optional[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse = {
    import GetOfferingStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse
      .builder()
      .optionallyWith(
        current.map(value =>
          value
            .map({ case (key, value) =>
              (OfferingIdentifier.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.current)
      .optionallyWith(
        nextPeriod.map(value =>
          value
            .map({ case (key, value) =>
              (OfferingIdentifier.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.nextPeriod)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly =
    zio.aws.devicefarm.model.GetOfferingStatusResponse.wrap(buildAwsValue())
}
object GetOfferingStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.GetOfferingStatusResponse =
      zio.aws.devicefarm.model.GetOfferingStatusResponse(
        current.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        nextPeriod.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        nextToken.map(value => value)
      )
    def current: Optional[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus.ReadOnly]
    ]
    def nextPeriod: Optional[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getCurrent: ZIO[Any, AwsError, Map[
      OfferingIdentifier,
      zio.aws.devicefarm.model.OfferingStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("current", current)
    def getNextPeriod: ZIO[Any, AwsError, Map[
      OfferingIdentifier,
      zio.aws.devicefarm.model.OfferingStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("nextPeriod", nextPeriod)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse
  ) extends zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly {
    override val current: Optional[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.current())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.devicefarm.model.primitives.OfferingIdentifier(
              key
            ) -> zio.aws.devicefarm.model.OfferingStatus.wrap(value)
          })
          .toMap
      )
    override val nextPeriod: Optional[
      Map[OfferingIdentifier, zio.aws.devicefarm.model.OfferingStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nextPeriod())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.devicefarm.model.primitives.OfferingIdentifier(
              key
            ) -> zio.aws.devicefarm.model.OfferingStatus.wrap(value)
          })
          .toMap
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.GetOfferingStatusResponse
  ): zio.aws.devicefarm.model.GetOfferingStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
