package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.{PaginationToken, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListArtifactsRequest(
    arn: AmazonResourceName,
    `type`: zio.aws.devicefarm.model.ArtifactCategory,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest = {
    import ListArtifactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListArtifactsRequest.ReadOnly =
    zio.aws.devicefarm.model.ListArtifactsRequest.wrap(buildAwsValue())
}
object ListArtifactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListArtifactsRequest =
      zio.aws.devicefarm.model
        .ListArtifactsRequest(arn, `type`, nextToken.map(value => value))
    def arn: AmazonResourceName
    def `type`: zio.aws.devicefarm.model.ArtifactCategory
    def nextToken: Optional[PaginationToken]
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
    def getType: ZIO[Any, Nothing, zio.aws.devicefarm.model.ArtifactCategory] =
      ZIO.succeed(`type`)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest
  ) extends zio.aws.devicefarm.model.ListArtifactsRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
    override val `type`: zio.aws.devicefarm.model.ArtifactCategory =
      zio.aws.devicefarm.model.ArtifactCategory.wrap(impl.`type`())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListArtifactsRequest
  ): zio.aws.devicefarm.model.ListArtifactsRequest.ReadOnly = new Wrapper(impl)
}
