package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDevicesResponse(
    devices: Optional[Iterable[zio.aws.devicefarm.model.Device]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse = {
    import ListDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse
      .builder()
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListDevicesResponse.ReadOnly =
    zio.aws.devicefarm.model.ListDevicesResponse.wrap(buildAwsValue())
}
object ListDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListDevicesResponse =
      zio.aws.devicefarm.model.ListDevicesResponse(
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def devices: Optional[List[zio.aws.devicefarm.model.Device.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getDevices
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Device.ReadOnly]] =
      AwsError.unwrapOptionField("devices", devices)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse
  ) extends zio.aws.devicefarm.model.ListDevicesResponse.ReadOnly {
    override val devices
        : Optional[List[zio.aws.devicefarm.model.Device.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.devices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Device.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListDevicesResponse
  ): zio.aws.devicefarm.model.ListDevicesResponse.ReadOnly = new Wrapper(impl)
}
