package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListOfferingsResponse(
    offerings: Optional[Iterable[zio.aws.devicefarm.model.Offering]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse = {
    import ListOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse
      .builder()
      .optionallyWith(
        offerings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.offerings)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListOfferingsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListOfferingsResponse.wrap(buildAwsValue())
}
object ListOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListOfferingsResponse =
      zio.aws.devicefarm.model.ListOfferingsResponse(
        offerings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def offerings: Optional[List[zio.aws.devicefarm.model.Offering.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getOfferings
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Offering.ReadOnly]] =
      AwsError.unwrapOptionField("offerings", offerings)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse
  ) extends zio.aws.devicefarm.model.ListOfferingsResponse.ReadOnly {
    override val offerings
        : Optional[List[zio.aws.devicefarm.model.Offering.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offerings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Offering.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListOfferingsResponse
  ): zio.aws.devicefarm.model.ListOfferingsResponse.ReadOnly = new Wrapper(impl)
}
