package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListProjectsResponse(
    projects: Optional[Iterable[zio.aws.devicefarm.model.Project]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse = {
    import ListProjectsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse
      .builder()
      .optionallyWith(
        projects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.projects)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListProjectsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListProjectsResponse.wrap(buildAwsValue())
}
object ListProjectsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListProjectsResponse =
      zio.aws.devicefarm.model.ListProjectsResponse(
        projects.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def projects: Optional[List[zio.aws.devicefarm.model.Project.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getProjects
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Project.ReadOnly]] =
      AwsError.unwrapOptionField("projects", projects)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse
  ) extends zio.aws.devicefarm.model.ListProjectsResponse.ReadOnly {
    override val projects
        : Optional[List[zio.aws.devicefarm.model.Project.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.projects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Project.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListProjectsResponse
  ): zio.aws.devicefarm.model.ListProjectsResponse.ReadOnly = new Wrapper(impl)
}
