package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSuitesResponse(
    suites: Optional[Iterable[zio.aws.devicefarm.model.Suite]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse = {
    import ListSuitesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse
      .builder()
      .optionallyWith(
        suites.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suites)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly =
    zio.aws.devicefarm.model.ListSuitesResponse.wrap(buildAwsValue())
}
object ListSuitesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListSuitesResponse =
      zio.aws.devicefarm.model.ListSuitesResponse(
        suites.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def suites: Optional[List[zio.aws.devicefarm.model.Suite.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getSuites
        : ZIO[Any, AwsError, List[zio.aws.devicefarm.model.Suite.ReadOnly]] =
      AwsError.unwrapOptionField("suites", suites)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse
  ) extends zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly {
    override val suites
        : Optional[List[zio.aws.devicefarm.model.Suite.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suites())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.Suite.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListSuitesResponse
  ): zio.aws.devicefarm.model.ListSuitesResponse.ReadOnly = new Wrapper(impl)
}
