package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTestGridSessionArtifactsResponse(
    artifacts: Optional[
      Iterable[zio.aws.devicefarm.model.TestGridSessionArtifact]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse = {
    import ListTestGridSessionArtifactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse
      .builder()
      .optionallyWith(
        artifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.artifacts)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse
      .wrap(buildAwsValue())
}
object ListTestGridSessionArtifactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse =
      zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse(
        artifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def artifacts: Optional[
      List[zio.aws.devicefarm.model.TestGridSessionArtifact.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getArtifacts: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.TestGridSessionArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("artifacts", artifacts)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse
  ) extends zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly {
    override val artifacts: Optional[
      List[zio.aws.devicefarm.model.TestGridSessionArtifact.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.artifacts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devicefarm.model.TestGridSessionArtifact.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionArtifactsResponse
  ): zio.aws.devicefarm.model.ListTestGridSessionArtifactsResponse.ReadOnly =
    new Wrapper(impl)
}
