package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTestGridSessionsResponse(
    testGridSessions: Optional[
      Iterable[zio.aws.devicefarm.model.TestGridSession]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse = {
    import ListTestGridSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse
      .builder()
      .optionallyWith(
        testGridSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.testGridSessions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.ListTestGridSessionsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListTestGridSessionsResponse.wrap(buildAwsValue())
}
object ListTestGridSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListTestGridSessionsResponse =
      zio.aws.devicefarm.model.ListTestGridSessionsResponse(
        testGridSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def testGridSessions
        : Optional[List[zio.aws.devicefarm.model.TestGridSession.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getTestGridSessions: ZIO[Any, AwsError, List[
      zio.aws.devicefarm.model.TestGridSession.ReadOnly
    ]] = AwsError.unwrapOptionField("testGridSessions", testGridSessions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse
  ) extends zio.aws.devicefarm.model.ListTestGridSessionsResponse.ReadOnly {
    override val testGridSessions
        : Optional[List[zio.aws.devicefarm.model.TestGridSession.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testGridSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devicefarm.model.TestGridSession.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionsResponse
  ): zio.aws.devicefarm.model.ListTestGridSessionsResponse.ReadOnly =
    new Wrapper(impl)
}
