package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListUniqueProblemsResponse(
    uniqueProblems: Optional[
      Map[zio.aws.devicefarm.model.ExecutionResult, Iterable[
        zio.aws.devicefarm.model.UniqueProblem
      ]]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse = {
    import ListUniqueProblemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse
      .builder()
      .optionallyWith(
        uniqueProblems.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.uniqueProblemsWithStrings)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.ListUniqueProblemsResponse.ReadOnly =
    zio.aws.devicefarm.model.ListUniqueProblemsResponse.wrap(buildAwsValue())
}
object ListUniqueProblemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.ListUniqueProblemsResponse =
      zio.aws.devicefarm.model.ListUniqueProblemsResponse(
        uniqueProblems.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        nextToken.map(value => value)
      )
    def uniqueProblems
        : Optional[Map[zio.aws.devicefarm.model.ExecutionResult, List[
          zio.aws.devicefarm.model.UniqueProblem.ReadOnly
        ]]]
    def nextToken: Optional[PaginationToken]
    def getUniqueProblems
        : ZIO[Any, AwsError, Map[zio.aws.devicefarm.model.ExecutionResult, List[
          zio.aws.devicefarm.model.UniqueProblem.ReadOnly
        ]]] = AwsError.unwrapOptionField("uniqueProblems", uniqueProblems)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse
  ) extends zio.aws.devicefarm.model.ListUniqueProblemsResponse.ReadOnly {
    override val uniqueProblems
        : Optional[Map[zio.aws.devicefarm.model.ExecutionResult, List[
          zio.aws.devicefarm.model.UniqueProblem.ReadOnly
        ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.uniqueProblems())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.devicefarm.model.ExecutionResult
              .wrap(key) -> value.asScala.map { item =>
              zio.aws.devicefarm.model.UniqueProblem.wrap(item)
            }.toList
          })
          .toMap
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devicefarm.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.ListUniqueProblemsResponse
  ): zio.aws.devicefarm.model.ListUniqueProblemsResponse.ReadOnly = new Wrapper(
    impl
  )
}
