package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MonetaryAmount(
    amount: Optional[Double] = Optional.Absent,
    currencyCode: Optional[zio.aws.devicefarm.model.CurrencyCode] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.MonetaryAmount = {
    import MonetaryAmount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.MonetaryAmount
      .builder()
      .optionallyWith(amount.map(value => value: java.lang.Double))(_.amount)
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.MonetaryAmount.ReadOnly =
    zio.aws.devicefarm.model.MonetaryAmount.wrap(buildAwsValue())
}
object MonetaryAmount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.MonetaryAmount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.MonetaryAmount =
      zio.aws.devicefarm.model.MonetaryAmount(
        amount.map(value => value),
        currencyCode.map(value => value)
      )
    def amount: Optional[Double]
    def currencyCode: Optional[zio.aws.devicefarm.model.CurrencyCode]
    def getAmount: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("amount", amount)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.CurrencyCode] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.MonetaryAmount
  ) extends zio.aws.devicefarm.model.MonetaryAmount.ReadOnly {
    override val amount: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.amount())
      .map(value => value: Double)
    override val currencyCode: Optional[zio.aws.devicefarm.model.CurrencyCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currencyCode())
        .map(value => zio.aws.devicefarm.model.CurrencyCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.MonetaryAmount
  ): zio.aws.devicefarm.model.MonetaryAmount.ReadOnly = new Wrapper(impl)
}
