package zio.aws.devicefarm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  DateTime,
  OfferingPromotionIdentifier,
  TransactionIdentifier
}
import scala.jdk.CollectionConverters.*
final case class OfferingTransaction(
    offeringStatus: Optional[zio.aws.devicefarm.model.OfferingStatus] =
      Optional.Absent,
    transactionId: Optional[TransactionIdentifier] = Optional.Absent,
    offeringPromotionId: Optional[OfferingPromotionIdentifier] =
      Optional.Absent,
    createdOn: Optional[DateTime] = Optional.Absent,
    cost: Optional[zio.aws.devicefarm.model.MonetaryAmount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.OfferingTransaction = {
    import OfferingTransaction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.OfferingTransaction
      .builder()
      .optionallyWith(offeringStatus.map(value => value.buildAwsValue()))(
        _.offeringStatus
      )
      .optionallyWith(
        transactionId.map(value =>
          TransactionIdentifier.unwrap(value): java.lang.String
        )
      )(_.transactionId)
      .optionallyWith(
        offeringPromotionId.map(value =>
          OfferingPromotionIdentifier.unwrap(value): java.lang.String
        )
      )(_.offeringPromotionId)
      .optionallyWith(createdOn.map(value => DateTime.unwrap(value): Instant))(
        _.createdOn
      )
      .optionallyWith(cost.map(value => value.buildAwsValue()))(_.cost)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.OfferingTransaction.ReadOnly =
    zio.aws.devicefarm.model.OfferingTransaction.wrap(buildAwsValue())
}
object OfferingTransaction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.OfferingTransaction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.OfferingTransaction =
      zio.aws.devicefarm.model.OfferingTransaction(
        offeringStatus.map(value => value.asEditable),
        transactionId.map(value => value),
        offeringPromotionId.map(value => value),
        createdOn.map(value => value),
        cost.map(value => value.asEditable)
      )
    def offeringStatus
        : Optional[zio.aws.devicefarm.model.OfferingStatus.ReadOnly]
    def transactionId: Optional[TransactionIdentifier]
    def offeringPromotionId: Optional[OfferingPromotionIdentifier]
    def createdOn: Optional[DateTime]
    def cost: Optional[zio.aws.devicefarm.model.MonetaryAmount.ReadOnly]
    def getOfferingStatus
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.OfferingStatus.ReadOnly] =
      AwsError.unwrapOptionField("offeringStatus", offeringStatus)
    def getTransactionId: ZIO[Any, AwsError, TransactionIdentifier] =
      AwsError.unwrapOptionField("transactionId", transactionId)
    def getOfferingPromotionId
        : ZIO[Any, AwsError, OfferingPromotionIdentifier] =
      AwsError.unwrapOptionField("offeringPromotionId", offeringPromotionId)
    def getCreatedOn: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdOn", createdOn)
    def getCost
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.MonetaryAmount.ReadOnly] =
      AwsError.unwrapOptionField("cost", cost)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.OfferingTransaction
  ) extends zio.aws.devicefarm.model.OfferingTransaction.ReadOnly {
    override val offeringStatus
        : Optional[zio.aws.devicefarm.model.OfferingStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringStatus())
        .map(value => zio.aws.devicefarm.model.OfferingStatus.wrap(value))
    override val transactionId: Optional[TransactionIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transactionId())
        .map(value =>
          zio.aws.devicefarm.model.primitives.TransactionIdentifier(value)
        )
    override val offeringPromotionId: Optional[OfferingPromotionIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringPromotionId())
        .map(value =>
          zio.aws.devicefarm.model.primitives.OfferingPromotionIdentifier(value)
        )
    override val createdOn: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdOn())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val cost
        : Optional[zio.aws.devicefarm.model.MonetaryAmount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cost())
        .map(value => zio.aws.devicefarm.model.MonetaryAmount.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.OfferingTransaction
  ): zio.aws.devicefarm.model.OfferingTransaction.ReadOnly = new Wrapper(impl)
}
