package zio.aws.devicefarm.model
import scala.jdk.CollectionConverters.*
sealed trait OfferingTransactionType {
  def unwrap
      : software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType
}
object OfferingTransactionType {
  def wrap(
      value: software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType
  ): zio.aws.devicefarm.model.OfferingTransactionType = value match {
    case software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType.PURCHASE =>
      val r = PURCHASE
      r
    case software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType.RENEW =>
      val r = RENEW
      r
    case software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType.SYSTEM =>
      val r = SYSTEM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devicefarm.model.OfferingTransactionType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType =
      software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType.UNKNOWN_TO_SDK_VERSION
  }
  case object PURCHASE
      extends zio.aws.devicefarm.model.OfferingTransactionType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType =
      software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType.PURCHASE
  }
  case object RENEW extends zio.aws.devicefarm.model.OfferingTransactionType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType =
      software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType.RENEW
  }
  case object SYSTEM extends zio.aws.devicefarm.model.OfferingTransactionType {
    override def unwrap
        : software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType =
      software.amazon.awssdk.services.devicefarm.model.OfferingTransactionType.SYSTEM
  }
}
