package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.Message
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Problem(
    run: Optional[zio.aws.devicefarm.model.ProblemDetail] = Optional.Absent,
    job: Optional[zio.aws.devicefarm.model.ProblemDetail] = Optional.Absent,
    suite: Optional[zio.aws.devicefarm.model.ProblemDetail] = Optional.Absent,
    test: Optional[zio.aws.devicefarm.model.ProblemDetail] = Optional.Absent,
    device: Optional[zio.aws.devicefarm.model.Device] = Optional.Absent,
    result: Optional[zio.aws.devicefarm.model.ExecutionResult] =
      Optional.Absent,
    message: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Problem = {
    import Problem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Problem
      .builder()
      .optionallyWith(run.map(value => value.buildAwsValue()))(_.run)
      .optionallyWith(job.map(value => value.buildAwsValue()))(_.job)
      .optionallyWith(suite.map(value => value.buildAwsValue()))(_.suite)
      .optionallyWith(test.map(value => value.buildAwsValue()))(_.test)
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .optionallyWith(result.map(value => value.unwrap))(_.result)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Problem.ReadOnly =
    zio.aws.devicefarm.model.Problem.wrap(buildAwsValue())
}
object Problem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.Problem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Problem =
      zio.aws.devicefarm.model.Problem(
        run.map(value => value.asEditable),
        job.map(value => value.asEditable),
        suite.map(value => value.asEditable),
        test.map(value => value.asEditable),
        device.map(value => value.asEditable),
        result.map(value => value),
        message.map(value => value)
      )
    def run: Optional[zio.aws.devicefarm.model.ProblemDetail.ReadOnly]
    def job: Optional[zio.aws.devicefarm.model.ProblemDetail.ReadOnly]
    def suite: Optional[zio.aws.devicefarm.model.ProblemDetail.ReadOnly]
    def test: Optional[zio.aws.devicefarm.model.ProblemDetail.ReadOnly]
    def device: Optional[zio.aws.devicefarm.model.Device.ReadOnly]
    def result: Optional[zio.aws.devicefarm.model.ExecutionResult]
    def message: Optional[Message]
    def getRun
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      AwsError.unwrapOptionField("run", run)
    def getJob
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      AwsError.unwrapOptionField("job", job)
    def getSuite
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      AwsError.unwrapOptionField("suite", suite)
    def getTest
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      AwsError.unwrapOptionField("test", test)
    def getDevice
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
    def getResult
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.ExecutionResult] =
      AwsError.unwrapOptionField("result", result)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Problem
  ) extends zio.aws.devicefarm.model.Problem.ReadOnly {
    override val run
        : Optional[zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.run())
        .map(value => zio.aws.devicefarm.model.ProblemDetail.wrap(value))
    override val job
        : Optional[zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.job())
        .map(value => zio.aws.devicefarm.model.ProblemDetail.wrap(value))
    override val suite
        : Optional[zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.suite())
        .map(value => zio.aws.devicefarm.model.ProblemDetail.wrap(value))
    override val test
        : Optional[zio.aws.devicefarm.model.ProblemDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.test())
        .map(value => zio.aws.devicefarm.model.ProblemDetail.wrap(value))
    override val device: Optional[zio.aws.devicefarm.model.Device.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.device())
        .map(value => zio.aws.devicefarm.model.Device.wrap(value))
    override val result: Optional[zio.aws.devicefarm.model.ExecutionResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value => zio.aws.devicefarm.model.ExecutionResult.wrap(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.devicefarm.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Problem
  ): zio.aws.devicefarm.model.Problem.ReadOnly = new Wrapper(impl)
}
