package zio.aws.devicefarm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devicefarm.model.primitives.{
  DateTime,
  JobTimeoutMinutes,
  Name,
  AmazonResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Project(
    arn: Optional[AmazonResourceName] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes] = Optional.Absent,
    created: Optional[DateTime] = Optional.Absent,
    vpcConfig: Optional[zio.aws.devicefarm.model.VpcConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.Project = {
    import Project.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Project
      .builder()
      .optionallyWith(
        arn.map(value => AmazonResourceName.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        defaultJobTimeoutMinutes.map(value =>
          JobTimeoutMinutes.unwrap(value): Integer
        )
      )(_.defaultJobTimeoutMinutes)
      .optionallyWith(created.map(value => DateTime.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Project.ReadOnly =
    zio.aws.devicefarm.model.Project.wrap(buildAwsValue())
}
object Project {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.Project
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Project =
      zio.aws.devicefarm.model.Project(
        arn.map(value => value),
        name.map(value => value),
        defaultJobTimeoutMinutes.map(value => value),
        created.map(value => value),
        vpcConfig.map(value => value.asEditable)
      )
    def arn: Optional[AmazonResourceName]
    def name: Optional[Name]
    def defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes]
    def created: Optional[DateTime]
    def vpcConfig: Optional[zio.aws.devicefarm.model.VpcConfig.ReadOnly]
    def getArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDefaultJobTimeoutMinutes: ZIO[Any, AwsError, JobTimeoutMinutes] =
      AwsError.unwrapOptionField(
        "defaultJobTimeoutMinutes",
        defaultJobTimeoutMinutes
      )
    def getCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("created", created)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Project
  ) extends zio.aws.devicefarm.model.Project.ReadOnly {
    override val arn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.devicefarm.model.primitives.AmazonResourceName(value)
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.devicefarm.model.primitives.Name(value))
    override val defaultJobTimeoutMinutes: Optional[JobTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultJobTimeoutMinutes())
        .map(value =>
          zio.aws.devicefarm.model.primitives.JobTimeoutMinutes(value)
        )
    override val created: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.devicefarm.model.primitives.DateTime(value))
    override val vpcConfig
        : Optional[zio.aws.devicefarm.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.devicefarm.model.VpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Project
  ): zio.aws.devicefarm.model.Project.ReadOnly = new Wrapper(impl)
}
