package zio.aws.devicefarm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Rule(
    attribute: Optional[zio.aws.devicefarm.model.DeviceAttribute] =
      Optional.Absent,
    operator: Optional[zio.aws.devicefarm.model.RuleOperator] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.devicefarm.model.Rule = {
    import Rule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.Rule
      .builder()
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .optionallyWith(operator.map(value => value.unwrap))(_.operator)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.devicefarm.model.Rule.ReadOnly =
    zio.aws.devicefarm.model.Rule.wrap(buildAwsValue())
}
object Rule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.devicefarm.model.Rule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.Rule =
      zio.aws.devicefarm.model.Rule(
        attribute.map(value => value),
        operator.map(value => value),
        value.map(value => value)
      )
    def attribute: Optional[zio.aws.devicefarm.model.DeviceAttribute]
    def operator: Optional[zio.aws.devicefarm.model.RuleOperator]
    def value: Optional[String]
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.devicefarm.model.DeviceAttribute] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getOperator: ZIO[Any, AwsError, zio.aws.devicefarm.model.RuleOperator] =
      AwsError.unwrapOptionField("operator", operator)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.Rule
  ) extends zio.aws.devicefarm.model.Rule.ReadOnly {
    override val attribute: Optional[zio.aws.devicefarm.model.DeviceAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value => zio.aws.devicefarm.model.DeviceAttribute.wrap(value))
    override val operator: Optional[zio.aws.devicefarm.model.RuleOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operator())
        .map(value => zio.aws.devicefarm.model.RuleOperator.wrap(value))
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.Rule
  ): zio.aws.devicefarm.model.Rule.ReadOnly = new Wrapper(impl)
}
