package zio.aws.devicefarm.model
import zio.aws.devicefarm.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopRemoteAccessSessionRequest(arn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionRequest = {
    import StopRemoteAccessSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionRequest
      .builder()
      .arn(AmazonResourceName.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.devicefarm.model.StopRemoteAccessSessionRequest.ReadOnly =
    zio.aws.devicefarm.model.StopRemoteAccessSessionRequest
      .wrap(buildAwsValue())
}
object StopRemoteAccessSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devicefarm.model.StopRemoteAccessSessionRequest =
      zio.aws.devicefarm.model.StopRemoteAccessSessionRequest(arn)
    def arn: AmazonResourceName
    def getArn: ZIO[Any, Nothing, AmazonResourceName] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionRequest
  ) extends zio.aws.devicefarm.model.StopRemoteAccessSessionRequest.ReadOnly {
    override val arn: AmazonResourceName =
      zio.aws.devicefarm.model.primitives.AmazonResourceName(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devicefarm.model.StopRemoteAccessSessionRequest
  ): zio.aws.devicefarm.model.StopRemoteAccessSessionRequest.ReadOnly =
    new Wrapper(impl)
}
